/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.ensemble;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.featureRanking.ensemble.ClusEnsembleFeatureRanking;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;

public class ClusEnsembleFeatureRankings {
    private HashMap<SettingsEnsemble.EnsembleRanking, ClusEnsembleFeatureRanking> m_Rankings = new HashMap();
    private Settings m_Settings;

    public ClusEnsembleFeatureRankings(Settings s) {
        List<SettingsEnsemble.EnsembleRanking> rankingTypes = s.getEnsemble().getRankingMethods();
        for (SettingsEnsemble.EnsembleRanking rankingType : rankingTypes) {
            this.m_Rankings.put(rankingType, new ClusEnsembleFeatureRanking(s, rankingType, this));
        }
    }

    public Settings getSettings() {
        return this.m_Settings;
    }

    public HashMap<SettingsEnsemble.EnsembleRanking, ClusEnsembleFeatureRanking> getRankings() {
        return this.m_Rankings;
    }

    public void initializeAttributes(ClusAttrType[] descriptive, HashMap<SettingsEnsemble.EnsembleRanking, Integer> nbRankings) {
        for (SettingsEnsemble.EnsembleRanking r : this.m_Rankings.keySet()) {
            this.m_Rankings.get((Object)r).initializeAttributes(descriptive, nbRankings.get((Object)r));
        }
    }

    public void setEnsembleRankigDescription(int realTrees) {
        for (SettingsEnsemble.EnsembleRanking r : this.m_Rankings.keySet()) {
            this.m_Rankings.get((Object)r).setEnsembleRankigDescription(realTrees);
        }
    }

    public void createFimp(ClusRun cr, String appendixToFimpName, int expectedNumberTrees, int realNumberOfTrees) throws IOException {
        for (SettingsEnsemble.EnsembleRanking r : this.m_Rankings.keySet()) {
            this.m_Rankings.get((Object)r).createFimp(cr, appendixToFimpName + r.toString(), expectedNumberTrees, realNumberOfTrees);
        }
    }

    public void putAttributesInfos(HashMap<SettingsEnsemble.EnsembleRanking, HashMap<String, double[][]>> importances) throws InterruptedException {
        for (SettingsEnsemble.EnsembleRanking r : this.m_Rankings.keySet()) {
            this.m_Rankings.get((Object)r).putAttributesInfos(importances.get((Object)r));
        }
    }
}

