/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.Accuracy;
import si.ijs.kt.clus.error.MisclassificationError;
import si.ijs.kt.clus.error.RMSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.error.hmlc.HierErrorMeasures;
import si.ijs.kt.clus.error.mlc.AveragePrecision;
import si.ijs.kt.clus.error.mlc.Coverage;
import si.ijs.kt.clus.error.mlc.HammingLoss;
import si.ijs.kt.clus.error.mlc.MLAccuracy;
import si.ijs.kt.clus.error.mlc.MLFOneMeasure;
import si.ijs.kt.clus.error.mlc.MLPrecision;
import si.ijs.kt.clus.error.mlc.MLRecall;
import si.ijs.kt.clus.error.mlc.MLaverageAUPRC;
import si.ijs.kt.clus.error.mlc.MLaverageAUROC;
import si.ijs.kt.clus.error.mlc.MLpooledAUPRC;
import si.ijs.kt.clus.error.mlc.MLweightedAUPRC;
import si.ijs.kt.clus.error.mlc.MacroFOne;
import si.ijs.kt.clus.error.mlc.MacroPrecision;
import si.ijs.kt.clus.error.mlc.MacroRecall;
import si.ijs.kt.clus.error.mlc.MicroPrecision;
import si.ijs.kt.clus.error.mlc.MicroRecall;
import si.ijs.kt.clus.error.mlc.OneError;
import si.ijs.kt.clus.error.mlc.RankingLoss;
import si.ijs.kt.clus.error.mlc.SubsetAccuracy;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.ensemble.ClusReadWriteLock;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.main.settings.section.SettingsMLC;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.selection.OOBSelection;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.tuple.Triple;

public class ClusFeatureRanking {
    protected final HashMap<String, double[]> m_AllAttributes = new HashMap();
    private FimpOrdering m_Order;
    private TreeMap<Double, ArrayList<Triple<String, int[], double[]>>> m_OutputRanking;
    private HashMap<String, Double> m_AttributeDatasetIndices;
    private HashMap<String, int[]> m_AttributeRanks;
    private String m_RankingDescription;
    protected String m_FimpTableHeader;
    ClusReadWriteLock m_Lock = new ClusReadWriteLock();
    private int m_NbFeatureRankings;
    private Settings m_Settings;
    private boolean m_ScoresNormalized = false;
    protected boolean m_IsEnsembleRanking = false;
    public static final String FIMP_SEPARATOR = "\t";
    public static final int FIMP_RELEVANCES_SIGNIFICANT_PLACES = 10;

    public ClusFeatureRanking(Settings sett) {
        this.m_AttributeDatasetIndices = new HashMap();
        this.m_OutputRanking = new TreeMap();
        this.m_Settings = sett;
    }

    public final Settings getSettings() {
        return this.m_Settings;
    }

    public void initializeAttributes(ClusAttrType[] descriptive, int nbRankings) {
        int num = -1;
        int nom = -1;
        int[] attributeDatasetIndices = descriptive[0].getSchema().getDescriptive().toIndices();
        for (int i = 0; i < descriptive.length; ++i) {
            ClusAttrType type = descriptive[i];
            this.m_AttributeDatasetIndices.put(type.getName(), Double.valueOf(attributeDatasetIndices[i]));
            if (type.isDisabled()) continue;
            double[] info = new double[2 + nbRankings];
            if (type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
                info[0] = 0.0;
                info[1] = ++nom;
            }
            if (type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Numeric)) {
                info[0] = 1.0;
                info[1] = ++num;
            }
            for (int j = 0; j < nbRankings; ++j) {
                info[2 + j] = 0.0;
            }
            this.m_AllAttributes.put(type.getName(), info);
        }
    }

    public void writeRanking(String fname) throws IOException {
        File franking = new File(fname + ".fimp");
        FileWriter wrtr = new FileWriter(franking);
        wrtr.write(this.m_RankingDescription + "\n");
        wrtr.write(this.m_FimpTableHeader + "\n");
        wrtr.write(StringUtils.makeString('-', this.m_FimpTableHeader.length()) + "\n");
        Set<Double> orderedKeys = this.m_Order == FimpOrdering.AS_IN_DATASET ? this.m_OutputRanking.keySet() : this.m_OutputRanking.descendingKeySet();
        for (Double key : orderedKeys) {
            ArrayList<Triple<String, int[], double[]>> triples = this.m_OutputRanking.get(key);
            for (Triple<String, int[], double[]> triple : triples) {
                wrtr.write(this.fimpTableRow(triple.getFirst(), triple.getSecond(), triple.getThird()) + "\n");
            }
        }
        wrtr.flush();
        wrtr.close();
        if (this.getSettings().getGeneral().getVerbose() >= 1) {
            ClusLogger.info(String.format("Feature importances written to: %s.fimp", fname));
        }
    }

    public String fimpTableRow(String attributeName, int[] ranks, double[] relevances) {
        int datasetIndex = (int)Math.round(this.m_AttributeDatasetIndices.get(attributeName));
        CharSequence[] output = new String[]{Integer.toString(datasetIndex), attributeName, Arrays.toString(ranks), Arrays.toString(relevances)};
        return String.join((CharSequence)FIMP_SEPARATOR, output);
    }

    public void writeJSON(ClusRun cr) throws IOException {
        String taskTypeString;
        Gson jsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject functionOutputJSON = new JsonObject();
        ClusSchema schema = cr.getStatManager().getSchema();
        JsonObject dataSpec = new JsonObject();
        JsonArray attributes = new JsonArray();
        JsonArray attributesTarget = new JsonArray();
        JsonArray attributesClustering = new JsonArray();
        JsonArray attributesDescriptive = new JsonArray();
        JsonObject task = new JsonObject();
        for (ClusAttrType a : schema.getAllAttrUse(ClusAttrType.AttributeUseType.All)) {
            attributes.add(a.getAttributeJSON());
        }
        for (ClusAttrType a : schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target)) {
            attributesTarget.add(new JsonPrimitive(a.getName()));
        }
        for (ClusAttrType a : schema.getAllAttrUse(ClusAttrType.AttributeUseType.Clustering)) {
            attributesClustering.add(new JsonPrimitive(a.getName()));
        }
        for (ClusAttrType a : schema.getAllAttrUse(ClusAttrType.AttributeUseType.Descriptive)) {
            attributesDescriptive.add(new JsonPrimitive(a.getName()));
        }
        String string = taskTypeString = schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target).length > 1 ? "MT " : "ST ";
        if (cr.getStatManager().getTargetMode() == ClusStatManager.Mode.REGRESSION) {
            taskTypeString = taskTypeString + "Regression";
        } else if (cr.getStatManager().getTargetMode() == ClusStatManager.Mode.CLASSIFY) {
            taskTypeString = taskTypeString + "Classification";
        }
        JsonPrimitive taskType = new JsonPrimitive(taskTypeString);
        task.add("taskType", taskType);
        task.add("taskDescriptiveAttributes", attributesDescriptive);
        task.add("taskTargetAttributes", attributesTarget);
        task.add("taskClusteringAttributes", attributesTarget);
        String queryValue = "Unable to get query details.";
        try {
            String fname = "query.param";
            File f = new File(fname);
            if (f.exists() && f.isFile()) {
                queryValue = new String(Files.readAllBytes(f.toPath()));
            }
        }
        catch (Exception fname) {
            // empty catch block
        }
        dataSpec.add("attributes", attributes);
        dataSpec.add("task", task);
        dataSpec.addProperty("query", queryValue);
        functionOutputJSON.add("dataSpecification", dataSpec);
        JsonObject algorithmSpec = new JsonObject();
        SettingsEnsemble.EnsembleMethod ens_method = this.getSettings().getEnsemble().getEnsembleMethod();
        SettingsEnsemble.EnsembleRanking fr_method = this.getSettings().getEnsemble().getRankingMethods().get(0);
        JsonPrimitive algorithmName = ens_method == SettingsEnsemble.EnsembleMethod.ExtraTrees ? new JsonPrimitive("ExtraTrees/GENIE3") : (ens_method == SettingsEnsemble.EnsembleMethod.RForest && fr_method == SettingsEnsemble.EnsembleRanking.RForest ? new JsonPrimitive("RandomForestRanking") : (ens_method == SettingsEnsemble.EnsembleMethod.RForest && fr_method == SettingsEnsemble.EnsembleRanking.Genie3 ? new JsonPrimitive("RandomForest/GENIE3") : new JsonPrimitive("Ranking method specified incorrectly!")));
        int ens_size = this.getSettings().getEnsemble().getNbBaggingSets().getInt();
        String feat_size = this.getSettings().getEnsemble().getNbRandomAttrString();
        JsonPrimitive parameters = new JsonPrimitive("Iterations: " + ens_size + "; SelectRandomSubspaces: " + feat_size);
        algorithmSpec.add("name", algorithmName);
        algorithmSpec.add("parameters", parameters);
        algorithmSpec.addProperty("version", "1.0");
        functionOutputJSON.add("algorithmSpecification", algorithmSpec);
        JsonArray rankingResults = new JsonArray();
        this.prepareFeatureRankingForOutput(FimpOrdering.BY_RELEVANCE);
        NavigableSet<Double> relevances = this.m_OutputRanking.descendingKeySet();
        int rankingIndex = 0;
        for (Double relevance : relevances) {
            ArrayList<Triple<String, int[], double[]>> nameRanksRelevancesTriples = this.m_OutputRanking.get(relevance);
            for (int i = 0; i < nameRanksRelevancesTriples.size(); ++i) {
                JsonObject elm = new JsonObject();
                elm.addProperty("attributeName", nameRanksRelevancesTriples.get(i).getFirst());
                elm.addProperty("ordering", nameRanksRelevancesTriples.get(i).getSecond()[rankingIndex]);
                elm.addProperty("importance", nameRanksRelevancesTriples.get(i).getThird()[rankingIndex]);
                rankingResults.add(elm);
            }
        }
        functionOutputJSON.add("ranking", rankingResults);
        File jsonfile = new File(this.getSettings().getGeneric().getAppName() + ".json");
        FileWriter json = new FileWriter(jsonfile);
        json.write(jsonBuilder.toJson(functionOutputJSON));
        json.flush();
        json.close();
        ClusLogger.info("JSON model written to: " + this.getSettings().getGeneric().getAppName() + ".json");
    }

    public RowData createRandomizedOOBdata(OOBSelection selection, RowData data, int type, int position, int seed) throws ClusException {
        RowData result = data;
        Random rndm = new Random(seed);
        for (int i = 0; i < result.getNbRows() - 1; ++i) {
            double swap;
            int rnd = i + rndm.nextInt(result.getNbRows() - i);
            DataTuple first = result.getTuple(i);
            DataTuple second = result.getTuple(rnd);
            boolean successfullySwapped = false;
            if (first instanceof SparseDataTuple) {
                if (type == 1) {
                    swap = ((SparseDataTuple)first).getDoubleValueSparse(position);
                    ((SparseDataTuple)first).setDoubleValueSparse(((SparseDataTuple)second).getDoubleValueSparse(position), position);
                    ((SparseDataTuple)second).setDoubleValueSparse(swap, position);
                    successfullySwapped = true;
                } else {
                    System.err.println("WARNING: type is not 1 (numeric). We will try to swap the values like in non-sparse case, but some things might go wrong, e.g.,\njava.lang.NullPointerException might occur.");
                }
            }
            if (successfullySwapped) continue;
            if (type == 0) {
                int swap2 = first.getIntVal(position);
                first.setIntVal(second.getIntVal(position), position);
                second.setIntVal(swap2, position);
                continue;
            }
            if (type == 1) {
                swap = first.getDoubleVal(position);
                first.setDoubleVal(second.getDoubleVal(position), position);
                second.setDoubleVal(swap, position);
                continue;
            }
            throw new ClusException("Error while making the random permutations for feature ranking!");
        }
        return result;
    }

    public ArrayList<String> getInternalAttributesNames(ClusNode root) {
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<ClusNode> stack = new ArrayList<ClusNode>();
        HashSet<String> discovered = new HashSet<String>();
        if (!root.atBottomLevel()) {
            stack.add(root);
        }
        while (stack.size() > 0) {
            ClusNode top = (ClusNode)stack.remove(stack.size() - 1);
            String name = top.getTest().getType().getName();
            if (!discovered.contains(name) && !top.atBottomLevel()) {
                discovered.add(name);
                attributes.add(name);
            }
            for (int i = 0; i < top.getNbChildren(); ++i) {
                if (top.getChild(i).atBottomLevel()) continue;
                stack.add((ClusNode)top.getChild(i));
            }
        }
        return attributes;
    }

    public double[][][] calcAverageErrors(RowData data, ClusModel model, ClusStatManager mgr) throws ClusException, InterruptedException {
        ClusSchema schema = data.getSchema();
        ClusErrorList error = this.computeErrorList(schema, mgr);
        schema.attachModel(model);
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            ClusStatistic pred = model.predictWeighted(tuple);
            error.addExample(tuple, pred);
        }
        double[][][] errors = new double[error.getNbErrors()][2][];
        for (int i = 0; i < errors.length; ++i) {
            ClusError currentError = error.getError(i);
            int nbResultsPerError = 1;
            if (mgr.getSettings().getEnsemble().shouldPerformRankingPerTarget() && currentError instanceof ComponentError) {
                nbResultsPerError += currentError.getDimension();
            }
            errors[i][0] = new double[nbResultsPerError];
            errors[i][0][0] = currentError.getModelError();
            for (int dim = 1; dim < errors[i][0].length; ++dim) {
                errors[i][0][dim] = currentError.getModelErrorComponent(dim - 1);
            }
            errors[i][1] = new double[]{currentError.shouldBeLow() ? -1.0 : 1.0};
        }
        return errors;
    }

    public ClusErrorList computeErrorList(ClusSchema schema, ClusStatManager mgr) {
        boolean hasNominal;
        Settings sett = mgr.getSettings();
        ClusErrorList error = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        boolean hasNumeric = num.length > 0;
        boolean bl = hasNominal = nom.length > 0;
        if (mgr.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            error.addError(new HierErrorMeasures(error, mgr.getHier(), sett.getHMLC().getRecallValues().getDoubleVector(), SettingsHMLC.HierarchyMeasures.PooledAUPRC, false, this.getSettings().getOutput().isGzipOutput()));
        } else {
            if (hasNominal && hasNumeric) {
                throw new UnsupportedOperationException("Unsupported! No error measure can handle numeric and nominal targets.");
            }
            if (hasNominal) {
                if (sett.getMLC().getSectionMultiLabel().isEnabled()) {
                    List<SettingsMLC.MultiLabelMeasures> measures = sett.getMLC().getMultiLabelRankingMeasures();
                    for (SettingsMLC.MultiLabelMeasures measure : measures) {
                        switch (measure) {
                            case HammingLoss: {
                                error.addError(new HammingLoss(error, nom));
                                break;
                            }
                            case MLAccuracy: {
                                error.addError(new MLAccuracy(error, nom));
                                break;
                            }
                            case MLPrecision: {
                                error.addError(new MLPrecision(error, nom));
                                break;
                            }
                            case MLRecall: {
                                error.addError(new MLRecall(error, nom));
                                break;
                            }
                            case MLFOne: {
                                error.addError(new MLFOneMeasure(error, nom));
                                break;
                            }
                            case SubsetAccuracy: {
                                error.addError(new SubsetAccuracy(error, nom));
                                break;
                            }
                            case MacroPrecision: {
                                error.addError(new MacroPrecision(error, nom));
                                break;
                            }
                            case MacroRecall: {
                                error.addError(new MacroRecall(error, nom));
                                break;
                            }
                            case MacroFOne: {
                                error.addError(new MacroFOne(error, nom));
                                break;
                            }
                            case MicroPrecision: {
                                error.addError(new MicroPrecision(error, nom));
                                break;
                            }
                            case MicroRecall: {
                                error.addError(new MicroRecall(error, nom));
                                break;
                            }
                            case MicroFOne: {
                                error.addError(new MisclassificationError(error, nom));
                                break;
                            }
                            case OneError: {
                                error.addError(new OneError(error, nom));
                                break;
                            }
                            case Coverage: {
                                error.addError(new Coverage(error, nom));
                                break;
                            }
                            case RankingLoss: {
                                error.addError(new RankingLoss(error, nom));
                                break;
                            }
                            case AveragePrecision: {
                                error.addError(new AveragePrecision(error, nom));
                                break;
                            }
                            case AverageAUROC: {
                                error.addError(new MLaverageAUROC(error, nom));
                                break;
                            }
                            case AverageAUPRC: {
                                error.addError(new MLaverageAUPRC(error, nom));
                                break;
                            }
                            case WeightedAverageAUPRC: {
                                error.addError(new MLweightedAUPRC(error, nom));
                                break;
                            }
                            case PooledAUPRC: {
                                error.addError(new MLpooledAUPRC(error, nom));
                                break;
                            }
                        }
                    }
                } else {
                    error.addError(new Accuracy(error, nom));
                }
            } else if (hasNumeric) {
                error.addError(new RMSError(error, num));
            } else {
                throw new UnsupportedOperationException("Unsupported!");
            }
        }
        return error;
    }

    public double[] getAttributeInfo(String attribute) throws InterruptedException {
        this.m_Lock.readingLock();
        double[] info = Arrays.copyOf(this.m_AllAttributes.get(attribute), this.m_AllAttributes.get(attribute).length);
        this.m_Lock.readingUnlock();
        return info;
    }

    public double getAttributeRelevance(String attribute, int rankingIndex) {
        return this.m_AllAttributes.get(attribute)[2 + rankingIndex];
    }

    public void putAttributeInfo(String attribute, double[] info) throws InterruptedException {
        this.m_Lock.writingLock();
        this.m_AllAttributes.put(attribute, info);
        this.m_Lock.writingUnlock();
    }

    public void putAttributesInfos(HashMap<String, double[][]> partialFimportances) throws InterruptedException {
        for (String attribute : partialFimportances.keySet()) {
            double[] info = this.getAttributeInfo(attribute);
            double[][] partialInfo = partialFimportances.get(attribute);
            int ind = 0;
            for (int i = 0; i < partialInfo.length; ++i) {
                for (int j = 0; j < partialInfo[i].length; ++j) {
                    int n = ind + 2;
                    info[n] = info[n] + partialInfo[i][j];
                    ++ind;
                }
            }
            this.putAttributeInfo(attribute, info);
        }
    }

    public void setFimpHeader(String header) {
        this.m_FimpTableHeader = header;
    }

    public void setRankingDescription(String descr) {
        this.m_RankingDescription = descr;
    }

    public String fimpTableHeader(Iterable<? extends CharSequence> list) {
        ArrayList<String> rankNames = new ArrayList<String>();
        for (CharSequence charSequence : list) {
            rankNames.add(charSequence + "Rank");
        }
        CharSequence[] header = new String[]{"attributeDatasetIndex", "attributeName", rankNames.toString(), "[" + String.join((CharSequence)", ", list) + "]"};
        return String.join((CharSequence)FIMP_SEPARATOR, header);
    }

    public String fimpTableHeader(CharSequence ... list) {
        ArrayList<String> rankNames = new ArrayList<String>();
        for (CharSequence elt : list) {
            rankNames.add(elt + "Rank");
        }
        CharSequence[] header = new String[]{"attributeDatasetIndex", "attributeName", rankNames.toString(), "[" + String.join((CharSequence)", ", list) + "]"};
        return String.join((CharSequence)FIMP_SEPARATOR, header);
    }

    public int getNbFeatureRankings() {
        return this.m_NbFeatureRankings;
    }

    public void setNbFeatureRankings(int nbRankings) {
        this.m_NbFeatureRankings = nbRankings;
    }

    public void createFimp(ClusRun cr) throws IOException {
        this.createFimp(cr, "", -1, -1);
    }

    public void createFimp(ClusRun cr, String appendixToFimpName, int expectedNumberTrees, int realNumberOfTrees) throws IOException {
        if (expectedNumberTrees != realNumberOfTrees) {
            String fileName = "fimp_manipulation.py";
            try {
                InputStream is = Clus.class.getResourceAsStream("/" + fileName);
                String fullFileName = this.getSettings().getGeneric().getFileAbsolute(fileName);
                Files.copy(is, Paths.get(fullFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                System.err.println("Error while copying " + fileName + " to the output folder.");
                ex.printStackTrace();
            }
        }
        this.m_Order = cr.getStatManager().getSettings().getEnsemble().shouldSortRankingByRelevance() ? FimpOrdering.BY_RELEVANCE : FimpOrdering.AS_IN_DATASET;
        if (this.m_Order == FimpOrdering.BY_RELEVANCE && this.getNbFeatureRankings() > 1 && this.getSettings().getGeneral().getVerbose() >= 1) {
            System.err.println("More than one feature ranking will be output. The attributes will be sorted with respect to the first ranking.");
        }
        this.computeFinalScores(realNumberOfTrees);
        this.computeRanks();
        this.prepareFeatureRankingForOutput();
        String appName = cr.getStatManager().getSettings().getGeneric().getFileAbsolute(cr.getStatManager().getSettings().getGeneric().getAppName()) + appendixToFimpName;
        this.writeRanking(appName);
        if (cr.getStatManager().getSettings().getOutput().isOutputJSONModel()) {
            this.writeJSON(cr);
        }
    }

    private void prepareFeatureRankingForOutput(FimpOrdering ordering) {
        for (String attributeName : this.m_AllAttributes.keySet()) {
            double[] scores = Arrays.copyOfRange(this.m_AllAttributes.get(attributeName), 2, 2 + this.m_NbFeatureRankings);
            Double key = ordering == FimpOrdering.AS_IN_DATASET ? this.m_AttributeDatasetIndices.get(attributeName) : Double.valueOf(scores[0]);
            if (!this.m_OutputRanking.containsKey(key)) {
                this.m_OutputRanking.put(key, new ArrayList());
            }
            this.m_OutputRanking.get(key).add(new Triple<String, int[], double[]>(attributeName, this.m_AttributeRanks.get(attributeName), scores));
        }
    }

    private void prepareFeatureRankingForOutput() {
        this.prepareFeatureRankingForOutput(this.m_Order);
    }

    public void computeFinalScores(int nb_trees) {
        for (String attributeName : this.m_AllAttributes.keySet()) {
            double[] possiblyNonnormalizedScores = this.m_AllAttributes.get(attributeName);
            for (int j = 0; j < this.m_NbFeatureRankings; ++j) {
                if (this.m_ScoresNormalized || !this.m_IsEnsembleRanking) continue;
                int n = 2 + j;
                possiblyNonnormalizedScores[n] = possiblyNonnormalizedScores[n] / (double)ClusEnsembleInduce.getMaxNbBags();
            }
        }
        this.m_ScoresNormalized = true;
    }

    private void computeRanks() {
        this.m_AttributeRanks = new HashMap();
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (String attributeName : this.m_AllAttributes.keySet()) {
            this.m_AttributeRanks.put(attributeName, new int[this.m_NbFeatureRankings]);
            attributeNames.add(attributeName);
        }
        for (int rankingInd = 0; rankingInd < this.m_NbFeatureRankings; ++rankingInd) {
            final int ind = 2 + rankingInd;
            Collections.sort(attributeNames, new Comparator<String>(){

                @Override
                public int compare(String attr1, String attr2) {
                    return Double.compare(ClusFeatureRanking.this.m_AllAttributes.get(attr2)[ind], ClusFeatureRanking.this.m_AllAttributes.get(attr1)[ind]);
                }
            });
            int lastRank = -200;
            double prevRelevance = Double.NaN;
            for (int i = 0; i < attributeNames.size(); ++i) {
                String attributeName = (String)attributeNames.get(i);
                double thisRelevance = this.m_AllAttributes.get(attributeName)[ind];
                if (!ClusUtil.eq(thisRelevance, prevRelevance, 1.0E-12)) {
                    lastRank = i + 1;
                }
                this.m_AttributeRanks.get((Object)attributeName)[rankingInd] = lastRank;
                prevRelevance = thisRelevance;
            }
        }
    }

    private static enum FimpOrdering {
        AS_IN_DATASET,
        BY_RELEVANCE;

    }
}

