/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.exhaustivesearch;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.exhaustivesearch.ClusExhaustiveSearch;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.io.ClusModelCollectionIO;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusExhaustiveInduce
extends ClusInductionAlgorithm {
    protected NominalSplit m_Split;
    protected ClusExhaustiveSearch m_Search;

    public ClusExhaustiveInduce(ClusSchema schema, Settings sett, ClusExhaustiveSearch search) throws ClusException, IOException {
        super(schema, sett);
        this.m_Search = search;
    }

    @Override
    public void initializeHeuristic() {
        this.m_Search.initializeHeuristic();
    }

    @Override
    public ClusData createData() {
        return new RowData(this.m_Schema);
    }

    @Override
    public boolean isModelWriter() {
        return true;
    }

    @Override
    public void writeModel(ClusModelCollectionIO strm) throws IOException, ClusException {
        this.m_Search.writeModel(strm);
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws ClusException, IOException {
        return null;
    }

    @Override
    public void induceAll(ClusRun cr) throws Exception {
        this.m_Search.exhaustiveSearch(cr);
        ClusModelInfo def_model = cr.addModelInfo(0);
        def_model.setModel(ClusDecisionTree.induceDefault(cr));
        def_model.setName("Default");
        ArrayList lst = this.m_Search.getBeam().toArray();
        for (int i = 0; i < lst.size(); ++i) {
            ClusBeamModel mdl = (ClusBeamModel)lst.get(i);
            ClusNode tree = (ClusNode)mdl.getModel();
            ClusModelInfo model_info = cr.addModelInfo(i);
            model_info.setModel(tree);
            model_info.setName("Beam " + (i + 1));
            model_info.clearAll();
        }
    }
}

