/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.exhaustivesearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.ConstraintDFInduce;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.constraint.ClusConstraintFile;
import si.ijs.kt.clus.ext.exhaustivesearch.ClusExhaustiveSearch;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.math.MDouble;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusExhaustiveDFSearch
extends ClusExhaustiveSearch {
    protected int m_cTree;

    public ClusExhaustiveDFSearch(Clus clus) throws ClusException, IOException {
        super(clus);
    }

    public int getCTree() {
        return this.m_cTree;
    }

    public void setCTree(int i) {
        this.m_cTree = i;
    }

    public void incCTree() {
        ++this.m_cTree;
    }

    public ClusBeamModel getRootNode(ClusRun run) throws Exception {
        ClusStatManager smanager = this.m_BeamInduce.getStatManager();
        Settings sett = smanager.getSettings();
        sett.getModel().setMinimalWeight(1.0);
        RowData train = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.m_Induce.createTotalClusteringStat(train);
        stat.calcMean();
        this.m_Induce.initSelectorAndSplit(stat);
        this.initSelector(this.m_Induce.getBestTest());
        ClusLogger.info("Root statistic: " + stat);
        ClusNode root = null;
        String constr_file = sett.getConstraints().getConstraintFile();
        if (StringUtils.unCaseCompare(constr_file, "None")) {
            root = new ClusNode();
            root.setClusteringStat(stat);
        } else {
            ClusConstraintFile file = ClusConstraintFile.getInstance();
            root = file.getClone(constr_file);
            root.setClusteringStat(stat);
            this.m_Induce.fillInStatsAndTests(root, train);
        }
        double weight = root.getClusteringStat().getTotalWeight();
        this.setTotalWeight(weight);
        double value = this.estimateBeamMeasure(root);
        return new ClusBeamModel(value, root);
    }

    public void refineGivenLeafExhaustiveDF(ClusNode leaf, ClusBeamModel root, ClusBeam beam, ClusAttrType[] attrs, ClusRun run) throws Exception {
        ClusNode ref_leaf;
        MyArray arr = (MyArray)leaf.getVisitor();
        RowData data = new RowData(arr.getObjects(), arr.size());
        if (this.m_Induce.initSelectorAndStopCrit(leaf, data)) {
            ClusLogger.info("stopping criterion reached in refineGivenLeafExhaustive");
            return;
        }
        if (leaf.getClusteringStat().getError() == 0.0) {
            return;
        }
        CurrentBestTestAndHeuristic sel = this.m_Induce.getBestTest();
        FindBestTest find = this.m_Induce.getFindBestTest();
        double base_value = root.getValue();
        double leaf_add = this.m_Heuristic.computeLeafAdd(leaf);
        this.m_Heuristic.setTreeOffset(base_value - leaf_add);
        int nbNewLeaves = 0;
        ClusNode[] newLeaves = new ClusNode[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            sel.resetBestTest();
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                find.findNominal((NominalAttrType)at, data, null);
            } else {
                find.findNumeric((NumericAttrType)at, data, null);
            }
            if (!sel.hasBestTest()) continue;
            ref_leaf = (ClusNode)leaf.cloneNode();
            ref_leaf.testToNode(sel);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Test: " + ref_leaf.getTestString() + " -> " + sel.m_BestHeur + " (" + ref_leaf.getTest().getPosFreq() + ")");
            }
            newLeaves[nbNewLeaves++] = ref_leaf;
        }
        ClusStatManager mgr = this.m_Induce.getStatManager();
        for (int i = 0; i < nbNewLeaves; ++i) {
            ref_leaf = newLeaves[i];
            int arity = ref_leaf.updateArity();
            NodeTest test = ref_leaf.getTest();
            for (int j = 0; j < arity; ++j) {
                ClusNode child = new ClusNode();
                ref_leaf.setChild(child, j);
                RowData subset = data.applyWeighted(test, j);
                child.initClusteringStat(mgr, subset);
                child.initTargetStat(mgr, subset);
                child.getTargetStat().calcMean();
            }
            ClusNode root_model = (ClusNode)root.getModel();
            ClusNode ref_tree = (ClusNode)root_model.cloneTree(leaf, ref_leaf);
            double new_heur = this.estimateBeamMeasure(ref_tree);
            ClusBeamModel new_model = new ClusBeamModel(new_heur, ref_tree);
            new_model.setParentModelIndex(this.getCurrentModel());
            this.refineModel(new_model, beam, run);
        }
    }

    public void refineEachLeafDF(ClusNode tree, ClusBeamModel root, ClusBeam beam, ClusAttrType[] attrs, ClusRun run) throws Exception {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            this.refineGivenLeafExhaustiveDF(tree, root, beam, attrs, run);
        } else {
            for (int i = nb_c - 1; i >= 0; --i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                this.refineEachLeafDF(child, root, beam, attrs, run);
                if (child.getNbChildren() > 0) break;
            }
        }
    }

    public static ArrayList getErrorPerleaf(ClusNode tree, MDouble sumLeftLeaves) {
        ArrayList listRightLeaves = new ArrayList();
        ClusExhaustiveDFSearch.getErrorPerleaf(tree, sumLeftLeaves, listRightLeaves);
        Collections.sort(listRightLeaves);
        return listRightLeaves;
    }

    public static void getErrorPerleaf(ClusNode tree, MDouble sumLeftLeaves, ArrayList listRightLeaves) {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ClusStatistic total = tree.getClusteringStat();
            listRightLeaves.add(new Double(total.getError()));
        } else {
            boolean foundRightMost = false;
            for (int i = nb_c - 1; i >= 0; --i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                if (foundRightMost) {
                    ClusExhaustiveDFSearch.getSumLeftLeavesError(child, sumLeftLeaves);
                } else {
                    ClusExhaustiveDFSearch.getErrorPerleaf(child, sumLeftLeaves, listRightLeaves);
                }
                if (child.getNbChildren() <= 0) continue;
                foundRightMost = true;
            }
        }
    }

    public static void getSumLeftLeavesError(ClusNode tree, MDouble sumLeftLeaves) {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ClusStatistic total = tree.getClusteringStat();
            sumLeftLeaves.addDouble(total.getError());
        } else {
            for (int i = 0; i < nb_c; ++i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                ClusExhaustiveDFSearch.getSumLeftLeavesError(child, sumLeftLeaves);
            }
        }
    }

    @Override
    public void refineModel(ClusBeamModel model, ClusBeam beam, ClusRun run) throws Exception {
        ClusNode tree = (ClusNode)model.getModel();
        int size = tree.getNbNodes();
        this.incCTree();
        boolean tree_ok = true;
        if (this.m_MaxTreeSize > 0 && size > this.m_MaxTreeSize) {
            tree_ok = false;
        }
        if (size > 1 && this.m_MaxError > 0.0 && ClusNode.estimateErrorRecursive(tree) / this.m_TotalWeight > this.m_MaxError) {
            tree_ok = false;
        }
        if (size == 1 && this.m_MaxError > 0.0 && tree.m_ClusteringStat.getErrorRel() > this.m_MaxError) {
            tree_ok = false;
        }
        if (tree_ok) {
            beam.addModel(model);
        }
        if (this.m_MaxTreeSize >= 0 && size + 2 > this.m_MaxTreeSize) {
            return;
        }
        if (this.m_MaxError > 0.0 && this.m_MaxTreeSize > 0) {
            int NbpossibleSplit = (this.m_MaxTreeSize - tree.getModelSize()) / 2;
            MDouble sumLeftLeaves = new MDouble();
            ArrayList error = ClusExhaustiveDFSearch.getErrorPerleaf(tree, sumLeftLeaves);
            if (error.size() > NbpossibleSplit) {
                double minerror = sumLeftLeaves.getDouble();
                for (int i = 0; i < error.size() - NbpossibleSplit; ++i) {
                    minerror += ((Double)error.get(i)).doubleValue();
                }
                double minerrorrel = minerror / this.m_TotalWeight;
                if (minerrorrel > this.m_MaxError) {
                    return;
                }
            }
        }
        RowData train = (RowData)run.getTrainingSet();
        this.m_Coll.initialize(tree, null);
        int nb_rows = train.getNbRows();
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = train.getTuple(i);
            tree.applyModelProcessor(tuple, this.m_Coll);
        }
        ClusAttrType[] attrs = train.getSchema().getDescriptiveAttributes();
        this.refineEachLeafDF(tree, model, beam, attrs, run);
        tree.clearVisitors();
    }

    @Override
    public ClusBeam exhaustiveSearch(ClusRun run) throws Exception {
        this.reset();
        ClusLogger.info("Starting exhaustive depth first search :");
        this.m_Induce = new ConstraintDFInduce(this.m_BeamInduce);
        ClusBeam beam = new ClusBeam(-1, false);
        ClusBeamModel current = this.getRootNode(run);
        this.refineModel(current, beam, run);
        this.setBeam(beam);
        ArrayList arraybeamresult = beam.toArray();
        ClusLogger.info("The number of resulting model is " + arraybeamresult.size());
        ClusLogger.info("The number of tree evaluated during search is " + this.getCTree());
        return beam;
    }
}

