/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.exhaustivesearch;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamTreeElem;

public class ClusExhaustive {
    TreeMap m_Tree = new TreeMap();
    Collection m_Values = this.m_Tree.values();
    int m_MaxWidth;
    int m_CrWidth;
    boolean m_RemoveEqualHeur;

    public ClusExhaustive(int width) {
        this.m_MaxWidth = width;
    }

    public int addIfNotIn(ClusBeamModel model) {
        Double key = new Double(model.getValue());
        ClusBeamTreeElem found = (ClusBeamTreeElem)this.m_Tree.get(key);
        if (found == null) {
            this.m_Tree.put(key, new ClusBeamTreeElem(model));
            return 1;
        }
        return 0;
    }

    public void print(PrintWriter wrt, int best_n) {
        ArrayList lst = this.toArray();
        for (int i = 0; i < Math.min(best_n, lst.size()); ++i) {
            if (i != 0) {
                wrt.println();
            }
            ClusBeamModel mdl = (ClusBeamModel)lst.get(lst.size() - i - 1);
            ClusNode tree = (ClusNode)mdl.getModel();
            double error = Double.NaN;
            wrt.println("Model: " + i + " value: " + mdl.getValue() + " error: " + error + " parent: " + mdl.getParentModelIndex());
            tree.printModel(wrt);
        }
    }

    public Iterator getIterator() {
        return this.m_Values.iterator();
    }

    public ArrayList toArray() {
        ArrayList lst = new ArrayList();
        for (ClusBeamTreeElem elem : this.m_Values) {
            elem.addAll(lst);
        }
        return lst;
    }

    public int getMaxWidth() {
        return this.m_MaxWidth;
    }

    public int getCrWidth() {
        return this.m_CrWidth;
    }

    public void print() {
    }
}

