/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble.ros;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ClusROSModelInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_TreeNumber;
    private HashMap<Integer, Integer> m_EnabledTargetAttributes;
    private HashSet<Integer> m_DisabledTargetAttributes;
    private int m_SizeOfSubspace;
    private String m_SubspaceString;
    private int m_SizeOfSubspaceSetting;
    private int m_NbTargetAttributes;
    private ArrayList<ClusROSModelInfo> m_Children;

    public void addChild(ClusROSModelInfo info) {
        this.m_Children.add(info);
    }

    public boolean isRandom() {
        return this.m_SizeOfSubspaceSetting < 0;
    }

    public boolean isRandomPerTree() {
        return this.isRandom() && this.m_SizeOfSubspaceSetting < -1;
    }

    public ArrayList<ClusROSModelInfo> getChildren() {
        return this.m_Children;
    }

    public int getNbChildren() {
        return this.m_Children.size();
    }

    public boolean isTargetEnabled(int targetIndex) {
        return this.m_EnabledTargetAttributes.keySet().contains(targetIndex);
    }

    public int getTreeNumber() {
        return this.m_TreeNumber;
    }

    public int getSizeOfSubspace() {
        return this.m_SizeOfSubspace;
    }

    public Set<Integer> getTargets() {
        return this.m_EnabledTargetAttributes.keySet();
    }

    public Set<Integer> getTargetsDisabled() {
        return this.m_DisabledTargetAttributes;
    }

    public String getSubspaceString() {
        return this.m_SubspaceString;
    }

    public ClusROSModelInfo(int treeNumber, int subspaceSizeSetting, HashMap<Integer, Integer> enabledTargetAttributes, int nbTargetAttributes) {
        this.m_TreeNumber = treeNumber;
        this.m_EnabledTargetAttributes = enabledTargetAttributes;
        this.m_DisabledTargetAttributes = new HashSet();
        this.m_SizeOfSubspace = enabledTargetAttributes.size();
        this.m_NbTargetAttributes = nbTargetAttributes;
        this.m_SizeOfSubspaceSetting = subspaceSizeSetting;
        this.m_SubspaceString = String.join((CharSequence)" ", this.m_EnabledTargetAttributes.keySet().stream().map(m -> (int)m).sorted().map(m -> Integer.toString(m)).collect(Collectors.toList()));
        this.m_Children = new ArrayList();
        for (int i = 0; i < nbTargetAttributes; ++i) {
            if (this.isTargetEnabled(i)) continue;
            this.m_DisabledTargetAttributes.add(i);
        }
    }

    public ClusROSModelInfo clone() {
        return new ClusROSModelInfo(this.m_TreeNumber, this.m_SizeOfSubspaceSetting, this.m_EnabledTargetAttributes, this.m_NbTargetAttributes);
    }

    public ClusROSModelInfo initWithNewSubspace(HashMap<Integer, Integer> newSubspace) {
        return new ClusROSModelInfo(this.m_TreeNumber, this.m_SizeOfSubspaceSetting, newSubspace, this.m_NbTargetAttributes);
    }

    public String toString() {
        return String.format("Tree Number: %d | Subspace: %s | SizeOfSubspace: %s | NbChildren: %d", this.m_TreeNumber, this.m_SubspaceString, this.m_SizeOfSubspace, this.m_Children.size());
    }
}

