/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble.ros;

import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.util.ClusUtil;

public class ClusROSForestInfo {
    private final ArrayList<ClusROSModelInfo> m_Trees = new ArrayList();
    private double[] m_Coverage;
    private ArrayList<Integer> m_Uncovered;
    private int[] m_CoverageOpt;
    private double[] m_CoverageNormalized;
    private double m_AverageTargetsUsed;
    private double m_AverageTargetsUsedPercentage;
    private final SettingsEnsemble.EnsembleROSAlgorithmType m_ROSAlgorithmType;
    private final SettingsEnsemble.EnsembleROSVotingType m_ROSVotingType;
    private final int m_NbTargetAttributes;
    private String m_StringValue;

    public ClusROSForestInfo(SettingsEnsemble.EnsembleROSAlgorithmType rosAlgorithmType, SettingsEnsemble.EnsembleROSVotingType rosVotingType, int nbTargetAttributes) {
        this.m_ROSAlgorithmType = rosAlgorithmType;
        this.m_ROSVotingType = rosVotingType;
        this.m_NbTargetAttributes = nbTargetAttributes;
        this.m_StringValue = null;
    }

    public SettingsEnsemble.EnsembleROSAlgorithmType getROSAlgorithmType() {
        return this.m_ROSAlgorithmType;
    }

    public SettingsEnsemble.EnsembleROSVotingType getROSVotingType() {
        return this.m_ROSVotingType;
    }

    public void addROSModelInfo(ClusROSModelInfo info) {
        this.m_Trees.add(info);
    }

    public ClusROSModelInfo getROSModelInfo(int treeNumber) {
        return this.m_Trees.stream().filter(p -> p.getTreeNumber() == treeNumber).findFirst().get();
    }

    private void calculateCoverage() {
        int i;
        this.m_Coverage = new double[this.m_NbTargetAttributes];
        this.m_Uncovered = new ArrayList();
        this.m_CoverageNormalized = new double[this.m_Coverage.length];
        this.m_AverageTargetsUsed = 0.0;
        this.m_AverageTargetsUsedPercentage = 0.0;
        Arrays.fill(this.m_Coverage, 0.0);
        block4: for (ClusROSModelInfo mi : this.m_Trees) {
            switch (this.m_ROSAlgorithmType) {
                case FixedSubspaces: {
                    for (Integer enabled : mi.getTargets()) {
                        int n = enabled;
                        this.m_Coverage[n] = this.m_Coverage[n] + 1.0;
                    }
                    continue block4;
                }
                case DynamicSubspaces: {
                    for (Integer enabled : mi.getTargets()) {
                        int n = enabled;
                        this.m_Coverage[n] = this.m_Coverage[n] + 1.0;
                    }
                    continue block4;
                }
                default: {
                    throw new RuntimeException("ROS: unable to calculate coverage.");
                }
            }
        }
        for (i = 0; i < this.m_CoverageNormalized.length; ++i) {
            this.m_CoverageNormalized[i] = ClusUtil.roundDouble(this.m_Coverage[i] / (double)this.m_Trees.size(), 3);
            this.m_AverageTargetsUsed += this.m_Coverage[i];
        }
        this.m_AverageTargetsUsedPercentage = ClusUtil.roundDouble(this.m_AverageTargetsUsed / (double)this.m_Trees.size() / (double)this.m_NbTargetAttributes * 100.0, 3);
        this.m_AverageTargetsUsed = ClusUtil.roundDouble(this.m_AverageTargetsUsed / (double)this.m_Trees.size(), 3);
        for (i = 0; i < this.m_Coverage.length; ++i) {
            if (this.m_Coverage[i] != 0.0) continue;
            this.m_Uncovered.add(i);
        }
    }

    public ArrayList<Integer> getTargetsNotLearned() {
        return this.m_Uncovered;
    }

    public String getCoverageInfo() {
        return String.format("Target coverage: %s", Arrays.toString(this.m_Coverage).replace(",", " "));
    }

    public String getCoverageNormalizedInfo() {
        return String.format("Target coverage normalized: %s", Arrays.toString(this.m_CoverageNormalized).replace(",", " "));
    }

    public String getAverageNumberOfTargetsUsedInfo() {
        return String.format("Average number of targets used per tree: %s | Average percentage of targets used per tree: %s", String.valueOf(this.m_AverageTargetsUsed), String.valueOf(this.m_AverageTargetsUsedPercentage) + "%");
    }

    public double[] getCoverage() {
        if (this.m_Coverage == null) {
            this.calculateCoverage();
        }
        return this.m_Coverage;
    }

    public ClusROSForestInfo getNew(int numberOfModels) {
        if (numberOfModels == this.m_Trees.size()) {
            if (this.m_Coverage == null) {
                this.calculateCoverage();
            }
            return this;
        }
        ClusROSForestInfo info = new ClusROSForestInfo(this.m_ROSAlgorithmType, this.m_ROSVotingType, this.m_NbTargetAttributes);
        for (int i = 0; i < numberOfModels; ++i) {
            info.addROSModelInfo(this.m_Trees.get(i));
        }
        info.calculateCoverage();
        return info;
    }

    public String toString() {
        if (this.m_StringValue != null) {
            return this.m_StringValue;
        }
        ArrayList<String> all = new ArrayList<String>();
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusROSModelInfo info = this.m_Trees.get(i);
            lst.clear();
            for (int m = 0; m < this.m_NbTargetAttributes; ++m) {
                if (info.isTargetEnabled(m)) {
                    lst.add(Integer.toString(m));
                    continue;
                }
                lst.add("-");
            }
            all.add(String.join((CharSequence)",", lst) + System.lineSeparator());
        }
        this.m_StringValue = String.join((CharSequence)System.lineSeparator(), all);
        return this.m_StringValue;
    }
}

