/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble.ros;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.util.ClusUtil;

public class ClusEnsembleROSInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<int[]> m_AllSubspaces;
    private double[] m_Coverage;
    private int[] m_CoverageOpt;
    private double m_AverageTargetsUsed;
    private ClusSchema m_Schema;
    private SettingsEnsemble.EnsembleROSAlgorithmType m_ROSAlgorithmType = null;
    private SettingsEnsemble.EnsembleROSVotingType m_ROSVotingType = null;
    private Integer m_ROSSubspaceSize = null;

    public ClusEnsembleROSInfo(ClusSchema schema, ArrayList<int[]> info, SettingsEnsemble.EnsembleROSAlgorithmType algorithmType, SettingsEnsemble.EnsembleROSVotingType votingType, int subspaceSize) {
        this.m_Schema = schema;
        this.m_ROSAlgorithmType = algorithmType;
        this.m_ROSVotingType = votingType;
        this.m_ROSSubspaceSize = subspaceSize;
        this.m_AllSubspaces = info;
        this.calculateCoverage();
        this.m_CoverageOpt = new int[this.m_Schema.getNbTargetAttributes()];
        for (int i = 0; i < this.m_CoverageOpt.length; ++i) {
            this.m_CoverageOpt[i] = 0;
        }
    }

    public int[] getModelSubspace(int i) {
        return this.m_AllSubspaces.get(i);
    }

    public boolean[] getModelSubspaceBoolean(int subspaceIdx) {
        int[] e = this.getModelSubspace(subspaceIdx);
        boolean[] b = new boolean[e.length];
        for (int j = 0; j < e.length; ++j) {
            b[j] = e[j] != 0;
        }
        return b;
    }

    public int[] getOnlyTargets(int[] enabled) {
        ClusAttrType[] targets = this.m_Schema.getTargetAttributes();
        int[] result = new int[targets.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = enabled[targets[i].getIndex()];
        }
        return result;
    }

    private void calculateCoverage() {
        int i;
        this.m_Coverage = new double[this.m_Schema.getNbTargetAttributes()];
        Arrays.fill(this.m_Coverage, 0.0);
        for (i = 0; i < this.m_AllSubspaces.size(); ++i) {
            int[] vals = this.getOnlyTargets(this.getModelSubspace(i));
            for (int t = 0; t < vals.length; ++t) {
                if (vals[t] != 1) continue;
                int n = t;
                this.m_Coverage[n] = this.m_Coverage[n] + 1.0;
            }
        }
        this.m_AverageTargetsUsed = 0.0;
        for (i = 0; i < this.m_Coverage.length; ++i) {
            this.m_AverageTargetsUsed += this.m_Coverage[i];
        }
        this.m_AverageTargetsUsed = ClusUtil.roundDouble(this.m_AverageTargetsUsed / (double)this.m_AllSubspaces.size(), 3);
    }

    public double[] getCoverage() {
        return this.m_Coverage;
    }

    public double[] getCoverageNormalized() {
        double[] d = new double[this.m_Coverage.length];
        for (int t = 0; t < this.m_Coverage.length; ++t) {
            d[t] = ClusUtil.roundDouble(this.m_Coverage[t] / (double)this.m_AllSubspaces.size(), 3);
        }
        return d;
    }

    public double getAverageNumberOfTargetsUsed() {
        return this.m_AverageTargetsUsed;
    }

    public String getInfo(int i) {
        int[] vals = this.getOnlyTargets(this.getModelSubspace(i));
        String sb = "";
        if (vals.length > 15) {
            sb = ClusEnsembleROSInfo.getEnabledCount(vals) + " of " + vals.length;
        } else {
            sb = "";
            ClusAttrType[] targets = this.m_Schema.getTargetAttributes();
            for (int t = 0; t < vals.length; ++t) {
                sb = vals[t] == 1 ? sb + (targets[t].getIndex() + 1) + "\t" : sb + "-\t";
            }
        }
        return sb;
    }

    public String getCoverageNormalizedInfo() {
        return String.format("Target coverage normalized: %s", Arrays.toString(this.getCoverageNormalized()).replace(",", " "));
    }

    public String getCoverageInfo() {
        return String.format("Target coverage: %s", Arrays.toString(this.m_Coverage).replace(",", " "));
    }

    public String getAverageNumberOfTargetsUsedInfo() {
        return String.format("Average number of targets used: %s | Average percentage of targets used: %s", String.valueOf(this.m_AverageTargetsUsed), String.valueOf(ClusUtil.roundDouble(this.m_AverageTargetsUsed / (double)this.m_Schema.getNbTargetAttributes() * 100.0, 3) + "%"));
    }

    public static int getEnabledCount(int[] enabled) {
        int cnt = 0;
        for (int i = 0; i < enabled.length; ++i) {
            if (enabled[i] != 1) continue;
            ++cnt;
        }
        return cnt;
    }

    public void incrementCoverageOpt(int[] enabled) {
        for (int b = 0; b < enabled.length; ++b) {
            if (enabled[b] != 1) continue;
            int n = b;
            this.m_CoverageOpt[n] = this.m_CoverageOpt[n] + 1;
        }
    }

    public int getCoverageOpt(int target) {
        return this.m_CoverageOpt[target];
    }

    public ClusEnsembleROSInfo getTrimmedInfo(int numberOfSubspaces) {
        if (numberOfSubspaces > this.m_AllSubspaces.size()) {
            throw new RuntimeException("number of subspaces > m_AllSubspaces.size()");
        }
        if (numberOfSubspaces == this.m_AllSubspaces.size()) {
            return this;
        }
        ArrayList<int[]> ary = new ArrayList<int[]>();
        for (int i = 0; i < numberOfSubspaces; ++i) {
            ary.add(this.m_AllSubspaces.get(i));
        }
        return new ClusEnsembleROSInfo(this.m_Schema, ary, this.m_ROSAlgorithmType, this.m_ROSVotingType, this.m_ROSSubspaceSize);
    }
}

