/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.bestfirst;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsGeneric;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class BestFirstInduce
extends ClusInductionAlgorithm {
    protected FindBestTest m_FindBestTest;
    protected ClusNode m_Root;

    public BestFirstInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
        this.m_FindBestTest = new FindBestTest(this.getStatManager());
    }

    public BestFirstInduce(ClusInductionAlgorithm other) {
        super(other);
        this.m_FindBestTest = new FindBestTest(this.getStatManager());
    }

    public BestFirstInduce(ClusInductionAlgorithm other, NominalSplit split) {
        super(other);
        this.m_FindBestTest = new FindBestTest(this.getStatManager(), split);
    }

    @Override
    public void initialize() throws ClusException, IOException {
        super.initialize();
    }

    public FindBestTest getFindBestTest() {
        return this.m_FindBestTest;
    }

    public CurrentBestTestAndHeuristic getBestTest() {
        return this.m_FindBestTest.getBestTest();
    }

    public boolean initSelectorAndStopCrit(ClusNode node, RowData data) {
        int max = this.getSettings().getConstraints().getTreeMaxDepth();
        if (max != -1 && node.getLevel() >= max) {
            return true;
        }
        return this.m_FindBestTest.initSelectorAndStopCrit(node.getClusteringStat(), data);
    }

    public ClusAttrType[] getDescriptiveAttributes() {
        ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.BestFirst_getDescriptiveAttributes);
        ClusSchema schema = this.getSchema();
        SettingsEnsemble sett = this.getSettings().getEnsemble();
        if (!sett.isEnsembleMode()) {
            return schema.getDescriptiveAttributes();
        }
        switch (sett.getEnsembleMethod()) {
            case Bagging: {
                return schema.getDescriptiveAttributes();
            }
            case RForest: {
                ClusAttrType[] attrsAll = schema.getDescriptiveAttributes();
                ClusEnsembleInduce.setRandomSubspaces(ClusEnsembleInduce.selectRandomSubspaces(attrsAll, schema.getSettings().getEnsemble().getNbRandomAttrSelected(), 1, null));
                return ClusEnsembleInduce.getRandomSubspaces();
            }
            case RSubspaces: {
                return ClusEnsembleInduce.getRandomSubspaces();
            }
            case BagSubspaces: {
                return ClusEnsembleInduce.getRandomSubspaces();
            }
            case RFeatSelection: {
                ClusAttrType[] attrsAll1 = schema.getDescriptiveAttributes();
                ClusEnsembleInduce.setRandomSubspaces(ClusEnsembleInduce.selectRandomSubspaces(attrsAll1, schema.getSettings().getEnsemble().getNbRandomAttrSelected(), 1, null));
                return ClusEnsembleInduce.getRandomSubspaces();
            }
        }
        return schema.getDescriptiveAttributes();
    }

    public void filterAlternativeSplits(ClusNode node, RowData data, RowData[] subsets) {
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        int arity = node.getTest().updateArity();
        ArrayList<NodeTest> v = best.getAlternativeBest();
        for (int k = 0; k < v.size(); ++k) {
            NodeTest nt = v.get(k);
            int altarity = nt.updateArity();
            if (altarity != arity) {
                v.remove(k);
                --k;
                ClusLogger.info("Alternative split with different arity: " + nt.getString());
                continue;
            }
            int nbsubset0 = subsets[0].getNbRows();
            int[] indices = new int[nbsubset0];
            for (int m = 0; m < nbsubset0; ++m) {
                indices[m] = subsets[0].getTuple(m).getIndex();
            }
            boolean same = false;
            for (int l = 0; l < altarity; ++l) {
                RowData altrd = data.applyWeighted(nt, l);
                if (altrd.getNbRows() != nbsubset0) continue;
                int nbsame = 0;
                for (int m = 0; m < nbsubset0; ++m) {
                    if (altrd.getTuple(m).getIndex() != indices[m]) continue;
                    ++nbsame;
                }
                if (nbsame != nbsubset0) continue;
                same = true;
                if (l == 0) continue;
                String test = ((Object)v.get(k)).toString();
                String newtest = "not(" + test + ")";
                v.set(k, (NodeTest)((Object)new String(newtest)));
            }
            if (same) continue;
            v.remove(k);
            --k;
            ClusLogger.info("Alternative split with different ex in subsets: " + nt.getString());
        }
        node.setAlternatives(v);
    }

    public void makeLeaf(ClusNode node) {
        node.makeLeaf();
        if (this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoClusteringStats)) {
            node.setClusteringStat(null);
        }
    }

    private int getBestNodeToSplit(ArrayList<ClusNode> listNodes) {
        int pos = 0;
        double best = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < listNodes.size(); ++j) {
            NodeTest bestTestNode = listNodes.get(j).getTest();
            double valueHeuristic = bestTestNode.getHeuristicValue();
            if (!(best < valueHeuristic)) continue;
            best = valueHeuristic;
            pos = j;
        }
        return pos;
    }

    public void inducePre(ClusNode node, RowData data) throws Exception {
        ArrayList<ClusNode> listNodes = new ArrayList<ClusNode>();
        ArrayList<RowData> subsets = new ArrayList<RowData>();
        ArrayList<RowData> dataLeaves = new ArrayList<RowData>();
        subsets.add(0, data);
        dataLeaves.add(0, data);
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
            return;
        }
        ClusAttrType[] attrs = this.getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, null);
                continue;
            }
            this.m_FindBestTest.findNumeric((NumericAttrType)at, data, null);
        }
        CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
        if (best.hasBestTest()) {
            node.testToNode(best);
            listNodes.add(node);
            this.induce(listNodes, subsets, dataLeaves, 0);
        } else {
            this.makeLeaf(node);
        }
    }

    public void induce(ArrayList<ClusNode> listNodes, ArrayList<RowData> subsets, ArrayList<RowData> dataLeaves, int bestTestIndex) throws Exception {
        ClusNode node = listNodes.get(bestTestIndex);
        RowData data = subsets.get(bestTestIndex);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Test: " + node.getTestString() + " -> " + node.getTest().getHeuristicValue());
        }
        int arity = node.updateArity();
        NodeTest test = node.getTest();
        listNodes.remove(bestTestIndex);
        subsets.remove(bestTestIndex);
        dataLeaves.remove(bestTestIndex);
        RowData[] subsetsLocal = new RowData[arity];
        for (int j = 0; j < arity; ++j) {
            subsets.add(data.applyWeighted(test, j));
            dataLeaves.add(subsets.size() - 1, subsets.get(subsets.size() - 1));
            subsetsLocal[j] = subsets.get(subsets.size() - 1);
        }
        if (this.initSelectorAndStopCrit(node, data)) {
            this.makeLeaf(node);
        }
        ClusAttrType[] attrs = this.getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, null);
                continue;
            }
            this.m_FindBestTest.findNumeric((NumericAttrType)at, data, null);
        }
        if (this.getSettings().getTree().showAlternativeSplits()) {
            this.filterAlternativeSplits(node, data, subsetsLocal);
        }
        if (node != this.m_Root && this.getSettings().getTree().hasTreeOptimize(SettingsTree.TreeOptimizeValues.NoInodeStats)) {
            node.setClusteringStat(null);
            node.setTargetStat(null);
        }
        for (int j = 0; j < arity; ++j) {
            ClusNode child = new ClusNode();
            node.setChild(child, j);
            child.initClusteringStat(this.m_StatManager, this.m_Root.getClusteringStat(), subsetsLocal[j]);
            child.initTargetStat(this.m_StatManager, this.m_Root.getTargetStat(), subsetsLocal[j]);
            if (this.initSelectorAndStopCrit(child, subsetsLocal[j])) {
                subsets.remove(subsetsLocal[j]);
                dataLeaves.remove(subsetsLocal[j]);
                dataLeaves.add(subsetsLocal[j]);
                this.makeLeaf(child);
                continue;
            }
            attrs = this.getDescriptiveAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                ClusAttrType at = attrs[i];
                if (at instanceof NominalAttrType) {
                    this.m_FindBestTest.findNominal((NominalAttrType)at, subsetsLocal[j], null);
                    continue;
                }
                this.m_FindBestTest.findNumeric((NumericAttrType)at, subsetsLocal[j], null);
            }
            CurrentBestTestAndHeuristic best = this.m_FindBestTest.getBestTest();
            if (best.hasBestTest()) {
                child.testToNode(best);
                listNodes.add(child);
                continue;
            }
            subsets.remove(subsetsLocal[j]);
            dataLeaves.remove(subsetsLocal[j]);
            dataLeaves.add(subsetsLocal[j]);
            this.makeLeaf(child);
        }
        if (listNodes.size() > 0) {
            bestTestIndex = this.getBestNodeToSplit(listNodes);
            this.induce(listNodes, subsets, dataLeaves, bestTestIndex);
        }
    }

    @Deprecated
    public void rankFeatures(ClusNode node, RowData data) throws Exception {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream("ranking.csv")));
        ClusAttrType[] attrs = this.getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            this.initSelectorAndStopCrit(node, data);
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data, null);
            } else {
                this.m_FindBestTest.findNumeric((NumericAttrType)at, data, null);
            }
            CurrentBestTestAndHeuristic cbt = this.m_FindBestTest.getBestTest();
            if (!cbt.hasBestTest()) continue;
            NodeTest test = cbt.updateTest();
            wrt.print(cbt.m_BestHeur);
            wrt.print(",\"" + at.getName() + "\"");
            wrt.println(",\"" + test + "\"");
        }
        wrt.close();
    }

    public void initSelectorAndSplit(ClusStatistic stat) throws ClusException {
        this.m_FindBestTest.initSelectorAndSplit(stat);
    }

    public void setInitialData(ClusStatistic stat, RowData data) throws ClusException {
        this.m_FindBestTest.setInitialData(stat, data);
    }

    public void cleanSplit() {
        this.m_FindBestTest.cleanSplit();
    }

    public ClusNode induceSingleUnpruned(RowData data) throws Exception {
        this.m_Root = null;
        do {
            this.m_Root = new ClusNode();
            this.m_Root.initClusteringStat(this.m_StatManager, data);
            this.m_Root.initTargetStat(this.m_StatManager, data);
            this.m_Root.getClusteringStat().showRootInfo();
            this.initSelectorAndSplit(this.m_Root.getClusteringStat());
            this.setInitialData(this.m_Root.getClusteringStat(), data);
            this.inducePre(this.m_Root, data);
        } while (SettingsGeneric.EXACT_TIME);
        this.m_Root.afterInduce(null);
        this.cleanSplit();
        return this.m_Root;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        return this.induceSingleUnpruned((RowData)cr.getTrainingSet());
    }
}

