/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.io.ClusTreeReader;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusBeamSyntacticConstraint {
    ClusNode m_Constraint;
    ArrayList<ClusStatistic> m_ConstraintPredictions;

    public ClusBeamSyntacticConstraint(ClusRun run) throws ClusException, IOException, InterruptedException {
        this.initializeConstraint(run);
        ClusStatManager mgr = run.getStatManager();
        mgr.getSchema().attachModel(this.m_Constraint);
        this.createConstrStat(this.m_Constraint, mgr, (RowData)run.getTrainingSet());
        this.setConstraintPredictions(this.getPredictions(run));
    }

    public void initializeConstraint(ClusRun run) throws IOException {
        ClusStatManager csm = run.getStatManager();
        ClusTreeReader rdr = new ClusTreeReader();
        String bconstrFile = csm.getSettings().getBeamSearch().getBeamConstraintFile();
        this.m_Constraint = rdr.loadTree(bconstrFile, csm.getSchema());
        this.m_Constraint.setClusteringStat(csm.createClusteringStat());
        this.m_Constraint.setTargetStat(csm.createTargetStat());
    }

    public void createConstrStat(ClusNode node, ClusStatManager mgr, RowData data) throws ClusException {
        if (node.getTest() == null) {
            node.makeLeaf();
        } else {
            for (int j = 0; j < node.getNbChildren(); ++j) {
                ClusNode child = (ClusNode)node.getChild(j);
                RowData subset = data.applyWeighted(node.getTest(), j);
                child.initClusteringStat(mgr, subset);
                child.initTargetStat(mgr, subset);
                child.getTargetStat().calcMean();
                this.createConstrStat(child, mgr, subset);
            }
        }
    }

    public ArrayList<ClusStatistic> getPredictions(ClusRun run) throws ClusException, InterruptedException {
        RowData train = (RowData)run.getTrainingSet();
        ArrayList<ClusStatistic> predictions = new ArrayList<ClusStatistic>();
        for (int i = 0; i < train.getNbRows(); ++i) {
            DataTuple tuple = train.getTuple(i);
            predictions.add(this.m_Constraint.predictWeighted(tuple));
        }
        return predictions;
    }

    public ArrayList<ClusStatistic> getConstraintPredictions() {
        return this.m_ConstraintPredictions;
    }

    public void setConstraintPredictions(ArrayList<ClusStatistic> predictions) {
        this.m_ConstraintPredictions = predictions;
    }
}

