/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.util.Arrays;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamAttrSelector;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSizeConstraintInfo;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusBeamSizeConstraints {
    protected int m_LeafCount;
    protected int m_StopCount;
    protected boolean m_IsModified;
    protected boolean m_Debug;

    public void enforce(ClusNode root, int size) {
        this.reset();
        ClusBeamSizeConstraints.initVisitors(root, size);
        ClusBeamSizeConstraints.computeCostUsingConstraints(root, size);
        ClusBeamSizeConstraintInfo info = (ClusBeamSizeConstraintInfo)root.getVisitor();
        this.pruneUsingConstraints(root, size, info.realcost[size]);
        this.pruneNonMarkedNodes(root);
        ClusBeamSizeConstraints.removeVisitors(root);
    }

    public boolean isModified() {
        return this.m_IsModified;
    }

    public boolean isFinished() {
        return this.m_StopCount >= this.m_LeafCount;
    }

    public void reset() {
        this.m_LeafCount = 0;
        this.m_StopCount = 0;
        this.m_IsModified = false;
    }

    public static double computeLowerBound(ClusStatistic stat, int l) {
        ClassificationStat cs = (ClassificationStat)stat;
        double[] clcnts = cs.getClassCounts(0);
        double[] c2 = new double[clcnts.length];
        System.arraycopy(clcnts, 0, c2, 0, c2.length);
        Arrays.sort(c2);
        int s = (l - 1) / 2;
        double result = 0.0;
        for (int i = s + 2; i <= c2.length; ++i) {
            result += c2[c2.length - i];
        }
        return result;
    }

    public static void computeCostUsingConstraints(ClusNode node, int l) {
        ClusBeamSizeConstraintInfo info = (ClusBeamSizeConstraintInfo)node.getVisitor();
        if (info.computed[l]) {
            return;
        }
        boolean is_leaf = node.atBottomLevel();
        if (l < 3 || is_leaf && ((ClusBeamAttrSelector)info.visitor).isStopCrit()) {
            info.realcost[l] = info.lowcost[l] = node.getClusteringStat().getError();
        } else if (is_leaf) {
            info.realcost[l] = node.getClusteringStat().getError();
            info.lowcost[l] = ClusBeamSizeConstraints.computeLowerBound(node.getClusteringStat(), l);
        } else {
            info.realcost[l] = info.lowcost[l] = node.getClusteringStat().getError();
            ClusNode ch1 = (ClusNode)node.getChild(0);
            ClusNode ch2 = (ClusNode)node.getChild(1);
            ClusBeamSizeConstraintInfo i1 = (ClusBeamSizeConstraintInfo)ch1.getVisitor();
            ClusBeamSizeConstraintInfo i2 = (ClusBeamSizeConstraintInfo)ch2.getVisitor();
            for (int k1 = 1; k1 <= l - 2; ++k1) {
                double lowcost2;
                double lowcost1;
                int k2 = l - k1 - 1;
                ClusBeamSizeConstraints.computeCostUsingConstraints(ch1, k1);
                ClusBeamSizeConstraints.computeCostUsingConstraints(ch2, k2);
                double realcost1 = i1.realcost[k1];
                double realcost2 = i2.realcost[k2];
                if (realcost1 + realcost2 < info.realcost[l]) {
                    info.realcost[l] = realcost1 + realcost2;
                }
                if (!((lowcost1 = i1.lowcost[k1]) + (lowcost2 = i2.lowcost[k2]) < info.lowcost[l])) continue;
                info.lowcost[l] = lowcost1 + lowcost2;
            }
        }
        info.computed[l] = true;
    }

    public void pruneUsingConstraints(ClusNode node, int l, double b) {
        ClusBeamSizeConstraintInfo info = (ClusBeamSizeConstraintInfo)node.getVisitor();
        info.marked = true;
        if (b <= info.bound[l]) {
            return;
        }
        for (int i = 1; i <= l; ++i) {
            if (!(b > info.bound[i])) continue;
            info.bound[i] = b;
        }
        if (info.lowcost[l] > b || Math.abs(info.lowcost[l] - node.getClusteringStat().getError()) < 1.0E-12) {
            return;
        }
        if (l >= 3 && !node.atBottomLevel()) {
            for (int k1 = 1; k1 <= l - 2; ++k1) {
                int k2 = l - k1 - 1;
                ClusNode ch1 = (ClusNode)node.getChild(0);
                ClusNode ch2 = (ClusNode)node.getChild(1);
                ClusBeamSizeConstraintInfo i1 = (ClusBeamSizeConstraintInfo)ch1.getVisitor();
                ClusBeamSizeConstraintInfo i2 = (ClusBeamSizeConstraintInfo)ch2.getVisitor();
                if (!(i1.lowcost[k1] + i2.lowcost[k2] <= b)) continue;
                double b1 = b - i2.lowcost[k2];
                double b2 = b - i1.lowcost[k1];
                this.pruneUsingConstraints(ch1, k1, b1);
                this.pruneUsingConstraints(ch2, k2, b2);
            }
        }
    }

    public void pruneNonMarkedNodes(ClusNode node) {
        ClusBeamSizeConstraintInfo info = (ClusBeamSizeConstraintInfo)node.getVisitor();
        if (node.atBottomLevel()) {
            ++this.m_LeafCount;
            ClusBeamAttrSelector attrsel = (ClusBeamAttrSelector)info.visitor;
            if (attrsel.isStopCrit()) {
                ++this.m_StopCount;
            }
        } else if (!info.marked) {
            ClusBeamAttrSelector attrsel = new ClusBeamAttrSelector();
            info.visitor = attrsel;
            node.makeLeaf();
            attrsel.setStopCrit(true);
            this.m_IsModified = true;
        } else {
            for (int i = 0; i < node.getNbChildren(); ++i) {
                ClusNode child = (ClusNode)node.getChild(i);
                this.pruneNonMarkedNodes(child);
            }
        }
    }

    public static void initVisitors(ClusNode node, int size) {
        ClusBeamSizeConstraintInfo info = new ClusBeamSizeConstraintInfo(size);
        info.visitor = node.getVisitor();
        node.setVisitor(info);
        for (int i = 0; i < node.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)node.getChild(i);
            ClusBeamSizeConstraints.initVisitors(child, size);
        }
    }

    public static void removeVisitors(ClusNode node) {
        ClusBeamSizeConstraintInfo info = (ClusBeamSizeConstraintInfo)node.getVisitor();
        node.setVisitor(info.visitor);
        for (int i = 0; i < node.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)node.getChild(i);
            ClusBeamSizeConstraints.removeVisitors(child);
        }
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }
}

