/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.util.ArrayList;
import org.apache.commons.lang.NotImplementedException;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;

public class ClusBeamSimRegrStat
extends RegressionStat {
    public static final long serialVersionUID = 1L;
    public double[] m_SumPredictions;
    public double[] m_SumSqPredictions;
    private ClusBeam m_Beam;

    public ClusBeamSimRegrStat(Settings sett, NumericAttrType[] attrs, ClusBeam beam) {
        super(sett, attrs);
        this.m_SumPredictions = new double[this.m_NbAttrs];
        this.m_SumSqPredictions = new double[this.m_NbAttrs];
        this.m_Beam = beam;
    }

    public ClusBeamSimRegrStat(Settings sett, NumericAttrType[] attrs, boolean onlymean, ClusBeam beam) {
        super(sett, attrs, onlymean);
        if (!onlymean) {
            this.m_SumPredictions = new double[this.m_NbAttrs];
            this.m_SumSqPredictions = new double[this.m_NbAttrs];
            this.m_Beam = beam;
        }
    }

    @Override
    public void calcMean(double[] means) {
        super.calcMean(means);
    }

    @Override
    public double getMean(int i) {
        return super.getMean(i);
    }

    @Override
    public double getSVarS(int i) {
        return super.getSVarS(i);
    }

    @Override
    public void add(ClusStatistic other) {
        super.add(other);
        ClusBeamSimRegrStat or = (ClusBeamSimRegrStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumPredictions[n] = this.m_SumPredictions[n] + or.m_SumPredictions[i];
            int n2 = i;
            this.m_SumSqPredictions[n2] = this.m_SumSqPredictions[n2] + or.m_SumSqPredictions[i];
        }
    }

    public void updateWeighted(SparseDataTuple tuple, double weight) {
        throw new NotImplementedException();
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        super.updateWeighted(tuple, weight);
        ArrayList models = this.m_Beam.toArray();
        double[] vals = new double[this.m_NbAttrs];
        double[] valssq = new double[this.m_NbAttrs];
        for (int k = 0; k < models.size(); ++k) {
            ClusBeamModel cbm = (ClusBeamModel)models.get(k);
            RegressionStat rstat = (RegressionStat)cbm.getPredictionForTuple(tuple);
            for (int i = 0; i < this.m_NbAttrs; ++i) {
                int n = i;
                vals[n] = vals[n] + rstat.getMean(i);
                int n2 = i;
                valssq[n2] = valssq[n2] + rstat.getMean(i) * rstat.getMean(i);
            }
        }
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumPredictions[n] = this.m_SumPredictions[n] + weight * vals[i];
            int n3 = i;
            this.m_SumSqPredictions[n3] = this.m_SumSqPredictions[n3] + weight * valssq[i];
        }
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        double result = super.getSVarS(scale);
        double similarity = 0.0;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double mean = super.getMean(i);
            double firstterm = this.m_SumWeight * (double)this.m_Beam.getCrWidth() * mean * mean;
            double secondterm = 2.0 * mean * this.getSumPredictions(i);
            double thirdterm = this.getSumSqPredictions(i);
            similarity += firstterm - secondterm + thirdterm;
            similarity *= scale.getWeight(this.m_Attrs[i]);
        }
        similarity /= (double)this.m_NbAttrs;
        return result += SettingsBeamSearch.BEAM_SIMILARITY * (similarity /= (double)this.m_Beam.getCrWidth());
    }

    @Override
    public ClusStatistic cloneStat() {
        return new ClusBeamSimRegrStat(this.m_Settings, this.m_Attrs, false, this.m_Beam);
    }

    @Override
    public ClusStatistic cloneSimple() {
        return new ClusBeamSimRegrStat(this.m_Settings, this.m_Attrs, true, this.m_Beam);
    }

    @Override
    public void copy(ClusStatistic other) {
        super.copy(other);
        ClusBeamSimRegrStat or = (ClusBeamSimRegrStat)other;
        System.arraycopy(or.m_SumPredictions, 0, this.m_SumPredictions, 0, this.m_NbAttrs);
        System.arraycopy(or.m_SumSqPredictions, 0, this.m_SumSqPredictions, 0, this.m_NbAttrs);
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        return super.getString(info);
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            this.m_SumPredictions[i] = 0.0;
            this.m_SumSqPredictions[i] = 0.0;
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        super.subtractFromOther(other);
        ClusBeamSimRegrStat or = (ClusBeamSimRegrStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            this.m_SumPredictions[i] = or.m_SumPredictions[i] - this.m_SumPredictions[i];
            this.m_SumSqPredictions[i] = or.m_SumSqPredictions[i] - this.m_SumSqPredictions[i];
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        super.subtractFromThis(other);
        ClusBeamSimRegrStat or = (ClusBeamSimRegrStat)other;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumPredictions[n] = this.m_SumPredictions[n] - or.m_SumPredictions[i];
            int n2 = i;
            this.m_SumSqPredictions[n2] = this.m_SumSqPredictions[n2] - or.m_SumSqPredictions[i];
        }
    }

    public double getSumPredictions(int i) {
        return this.m_SumPredictions[i];
    }

    public double[] getSumPredictions() {
        return this.m_SumPredictions;
    }

    public double getSumSqPredictions(int i) {
        return this.m_SumSqPredictions[i];
    }

    public double[] getSumSqPredictions() {
        return this.m_SumSqPredictions;
    }

    @Override
    public void setBeam(ClusBeam beam) {
        this.m_Beam = beam;
    }
}

