/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.util.ArrayList;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusBeamSimClassStat
extends ClassificationStat {
    private static final long serialVersionUID = 1L;
    public double[][] m_SumPredictions;
    public double[][] m_SumSqPredictions;
    private ClusBeam m_Beam;

    public ClusBeamSimClassStat(Settings sett, NominalAttrType[] nomAtts, ClusBeam beam) {
        super(sett, nomAtts);
        this.m_Beam = beam;
        this.m_SumPredictions = this.replicateEmpty(this.m_ClassCounts);
        this.m_SumSqPredictions = this.replicateEmpty(this.m_ClassCounts);
    }

    @Override
    public ClusStatistic cloneStat() {
        return new ClusBeamSimClassStat(this.m_Settings, this.m_Attrs, this.m_Beam);
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.m_NbTarget; ++i) {
            for (int j = 0; j < this.m_SumPredictions[i].length; ++j) {
                this.m_SumPredictions[i][j] = 0.0;
                this.m_SumSqPredictions[i][j] = 0.0;
            }
        }
    }

    @Override
    public void copy(ClusStatistic other) {
        super.copy(other);
        ClusBeamSimClassStat or = (ClusBeamSimClassStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] my = this.m_SumPredictions[i];
            double[] your = or.m_SumPredictions[i];
            System.arraycopy(your, 0, my, 0, my.length);
            my = this.m_SumSqPredictions[i];
            your = or.m_SumSqPredictions[i];
            System.arraycopy(your, 0, my, 0, my.length);
        }
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        super.addPrediction(other, weight);
        ClusBeamSimClassStat or = (ClusBeamSimClassStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] mysum = this.m_SumPredictions[i];
            double[] yoursum = or.m_SumPredictions[i];
            double[] mysumsq = this.m_SumSqPredictions[i];
            double[] yoursumsq = or.m_SumSqPredictions[i];
            for (int j = 0; j < mysum.length; ++j) {
                int n = j;
                mysum[n] = mysum[n] + weight * yoursum[j];
                int n2 = j;
                mysumsq[n2] = mysumsq[n2] + weight * yoursumsq[j];
            }
        }
    }

    @Override
    public void add(ClusStatistic other) {
        super.add(other);
        ClusBeamSimClassStat or = (ClusBeamSimClassStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] mysum = this.m_SumPredictions[i];
            double[] yoursum = or.m_SumPredictions[i];
            double[] mysumsq = this.m_SumSqPredictions[i];
            double[] yoursumsq = or.m_SumSqPredictions[i];
            for (int j = 0; j < mysum.length; ++j) {
                int n = j;
                mysum[n] = mysum[n] + yoursum[j];
                int n2 = j;
                mysumsq[n2] = mysumsq[n2] + yoursumsq[j];
            }
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        super.subtractFromThis(other);
        ClusBeamSimClassStat or = (ClusBeamSimClassStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] mysum = this.m_SumPredictions[i];
            double[] yoursum = or.m_SumPredictions[i];
            double[] mysumsq = this.m_SumPredictions[i];
            double[] yoursumsq = or.m_SumPredictions[i];
            for (int j = 0; j < mysum.length; ++j) {
                int n = j;
                mysum[n] = mysum[n] - yoursum[j];
                int n2 = j;
                mysumsq[n2] = mysumsq[n2] - yoursumsq[j];
            }
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        super.subtractFromOther(other);
        ClusBeamSimClassStat or = (ClusBeamSimClassStat)other;
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double[] mysum = this.m_SumPredictions[i];
            double[] yoursum = or.m_SumPredictions[i];
            double[] mysumsq = this.m_SumPredictions[i];
            double[] yoursumsq = or.m_SumPredictions[i];
            for (int j = 0; j < mysum.length; ++j) {
                mysum[j] = yoursum[j] - mysum[j];
                mysumsq[j] = yoursumsq[j] - mysumsq[j];
            }
        }
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.updateWeighted(tuple, tuple.getWeight());
    }

    public void updateWeighted(SparseDataTuple tuple, int idx) {
        this.updateWeighted((DataTuple)tuple, tuple.getWeight());
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        super.updateWeighted(tuple, weight);
        ArrayList models = this.m_Beam.toArray();
        double[][] vals = this.replicateEmpty(this.m_SumPredictions);
        double[][] valssq = this.replicateEmpty(this.m_SumSqPredictions);
        for (int k = 0; k < models.size(); ++k) {
            ClusBeamModel cbm = (ClusBeamModel)models.get(k);
            ClassificationStat cstat = (ClassificationStat)cbm.getPredictionForTuple(tuple);
            double[][] cvals = cstat.getProbabilityPrediction();
            for (int i = 0; i < this.m_NbTarget; ++i) {
                for (int j = 0; j < cvals[i].length; ++j) {
                    double[] dArray = vals[i];
                    int n = j;
                    dArray[n] = dArray[n] + cvals[i][j];
                    double[] dArray2 = valssq[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + cvals[i][j] * cvals[i][j];
                }
            }
        }
        for (int m = 0; m < this.m_SumPredictions.length; ++m) {
            for (int n = 0; n < this.m_SumPredictions[m].length; ++n) {
                double[] dArray = this.m_SumPredictions[m];
                int n3 = n;
                dArray[n3] = dArray[n3] + weight * vals[m][n];
                double[] dArray3 = this.m_SumSqPredictions[m];
                int n4 = n;
                dArray3[n4] = dArray3[n4] + weight * valssq[m][n];
            }
        }
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        double result = super.getSVarS(scale);
        double similarity = 0.0;
        double[][] probdistr = this.getProbabilityPrediction();
        for (int i = 0; i < this.m_NbTarget; ++i) {
            double firstterm = 0.0;
            double secondterm = 0.0;
            double thirdterm = 0.0;
            for (int j = 0; j < this.m_SumPredictions[i].length; ++j) {
                firstterm += probdistr[i][j] * probdistr[i][j];
                secondterm += 2.0 * probdistr[i][j] * this.getSumPrediction(i, j);
                thirdterm += this.getSumSqPrediction(i, j);
            }
            similarity += firstterm - secondterm + thirdterm;
            similarity *= scale.getWeight(this.m_Attrs[i]);
        }
        similarity /= (double)this.m_NbTarget;
        return result += SettingsBeamSearch.BEAM_SIMILARITY * (similarity /= (double)this.m_Beam.getCrWidth());
    }

    public double[][] replicateEmpty(double[][] values) {
        double[][] result = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new double[values[i].length];
        }
        return result;
    }

    public double getSumPrediction(int target, int classval) {
        return this.m_SumPredictions[target][classval];
    }

    public double[] getSumPrediction(int target) {
        return this.m_SumPredictions[target];
    }

    public double getSumSqPrediction(int target, int classval) {
        return this.m_SumSqPredictions[target][classval];
    }

    public double[] getSumSqPrediction(int target) {
        return this.m_SumSqPredictions[target];
    }

    @Override
    public void setBeam(ClusBeam beam) {
        this.m_Beam = beam;
    }
}

