/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSyntacticConstraint;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusBeamModelDistance {
    RowData m_Data;
    int m_NbRows;
    boolean isBeamUpdated = false;

    public ClusBeamModelDistance(ClusRun run, ClusBeam beam) throws ClusException, InterruptedException {
        this.m_Data = (RowData)run.getTrainingSet();
        if (this.m_Data == null) {
            throw new ClusException(this.getClass().getName() + ": ClusBeamTreeDistance(): Error while reading the train data");
        }
        this.m_NbRows = this.m_Data.getNbRows();
        this.fillBeamWithPredictions(beam);
    }

    public void fillBeamWithPredictions(ClusBeam beam) throws ClusException, InterruptedException {
        ArrayList arr = beam.toArray();
        for (int k = 0; k < arr.size(); ++k) {
            ClusBeamModel model = (ClusBeamModel)arr.get(k);
            model.setModelPredictions(this.getPredictions(model.getModel()));
        }
    }

    public ArrayList<ClusStatistic> getPredictions(ClusModel model) throws ClusException, InterruptedException {
        ArrayList<ClusStatistic> predictions = new ArrayList<ClusStatistic>();
        for (int i = 0; i < this.m_NbRows; ++i) {
            DataTuple tuple = this.m_Data.getTuple(i);
            ClusStatistic stat = model.predictWeighted(tuple);
            predictions.add(tuple.getIndex(), stat);
        }
        return predictions;
    }

    public static ArrayList<ClusStatistic> getPredictionsDataSet(ClusModel model, RowData train, boolean isNum) throws ClusException, InterruptedException {
        ArrayList<ClusStatistic> predictions = new ArrayList<ClusStatistic>();
        for (int i = 0; i < train.getNbRows(); ++i) {
            DataTuple tuple = train.getTuple(i);
            ClusStatistic stat = model.predictWeighted(tuple);
            predictions.add(stat);
        }
        return predictions;
    }

    public static double getDistance(ArrayList<ClusStatistic> a, ArrayList<ClusStatistic> b) {
        double result = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            ClusStatistic first = a.get(i);
            ClusStatistic second = b.get(i);
            result += first.getSquaredDistance(second);
        }
        return result / (double)a.size();
    }

    public void calculatePredictionDistances(ClusBeam beam, ClusBeamModel candidate) {
        ArrayList arr = beam.toArray();
        ArrayList<ClusStatistic> predCandidate = candidate.getModelPredictions();
        double candidateDist = 0.0;
        for (int i = 0; i < arr.size(); ++i) {
            ClusBeamModel beamModel1 = (ClusBeamModel)arr.get(i);
            ArrayList<ClusStatistic> predModel1 = beamModel1.getModelPredictions();
            double dist = 0.0;
            for (int j = 0; j < arr.size(); ++j) {
                ClusBeamModel beamModel2 = (ClusBeamModel)arr.get(j);
                ArrayList<ClusStatistic> predModel2 = beamModel2.getModelPredictions();
                dist += ClusBeamModelDistance.getDistance(predModel1, predModel2);
            }
            double cdist = ClusBeamModelDistance.getDistance(predModel1, predCandidate);
            candidateDist += cdist;
            beamModel1.setDistanceToBeam(dist += cdist);
        }
        candidate.setDistanceToBeam(candidateDist);
    }

    public void calculatePredictionDistancesOpt(ClusBeam beam, ClusBeamModel candidate) {
        ArrayList arr = beam.toArray();
        int size = arr.size();
        ArrayList<ClusStatistic> predCandidate = candidate.getModelPredictions();
        double candidateDist = 0.0;
        double[] tempDist = new double[size];
        double temp = 0.0;
        for (int i = 0; i < size - 1; ++i) {
            ClusBeamModel beamModel1 = (ClusBeamModel)arr.get(i);
            ArrayList<ClusStatistic> predModel1 = beamModel1.getModelPredictions();
            int j = i + 1;
            while (j < size) {
                ClusBeamModel beamModel2 = (ClusBeamModel)arr.get(j);
                ArrayList<ClusStatistic> predModel2 = beamModel2.getModelPredictions();
                temp = ClusBeamModelDistance.getDistance(predModel1, predModel2);
                int n = i;
                tempDist[n] = tempDist[n] + temp;
                int n2 = j++;
                tempDist[n2] = tempDist[n2] + temp;
            }
            temp = ClusBeamModelDistance.getDistance(predModel1, predCandidate);
            int n = i;
            tempDist[n] = tempDist[n] + temp;
            candidateDist += temp;
            beamModel1.setDistanceToBeam(tempDist[i]);
        }
        temp = ClusBeamModelDistance.getDistance(((ClusBeamModel)arr.get(size - 1)).getModelPredictions(), predCandidate);
        int n = size - 1;
        tempDist[n] = tempDist[n] + temp;
        ((ClusBeamModel)arr.get(size - 1)).setDistanceToBeam(tempDist[size - 1]);
        candidate.setDistanceToBeam(candidateDist += temp);
    }

    public void addDistToCandOpt(ClusBeam beam, ClusBeamModel candidate) {
        ArrayList arr = beam.toArray();
        int size = arr.size();
        ArrayList<ClusStatistic> candidatepredictions = candidate.getModelPredictions();
        double dist = 0.0;
        double candidatedist = 0.0;
        for (int i = 0; i < size; ++i) {
            ClusBeamModel model = (ClusBeamModel)arr.get(i);
            dist = ClusBeamModelDistance.getDistance(model.getModelPredictions(), candidatepredictions);
            candidatedist += dist;
            double distance = model.getDistanceToBeam();
            model.setDistanceToBeam(distance += dist);
        }
        candidate.setDistanceToBeam(candidatedist);
    }

    public void deductFromBeamOpt(ClusBeam beam, ClusBeamModel candidate, int position) {
        ArrayList arr = beam.toArray();
        int size = arr.size();
        ArrayList<ClusStatistic> candidatepredictions = candidate.getModelPredictions();
        double dist = 0.0;
        if (position == size) {
            for (int i = 0; i < size; ++i) {
                ClusBeamModel model = (ClusBeamModel)arr.get(i);
                dist = ClusBeamModelDistance.getDistance(model.getModelPredictions(), candidatepredictions);
                double distance = model.getDistanceToBeam();
                model.setDistanceToBeam(distance -= dist);
            }
        } else {
            double distance;
            ClusBeamModel exitmodel = (ClusBeamModel)arr.get(position);
            ArrayList<ClusStatistic> exitpredictions = exitmodel.getModelPredictions();
            for (int j = 0; j < size; ++j) {
                if (j == position) continue;
                ClusBeamModel model = (ClusBeamModel)arr.get(j);
                dist = ClusBeamModelDistance.getDistance(model.getModelPredictions(), exitpredictions);
                distance = model.getDistanceToBeam();
                model.setDistanceToBeam(distance -= dist);
            }
            dist = ClusBeamModelDistance.getDistance(candidatepredictions, exitpredictions);
            distance = candidate.getDistanceToBeam();
            candidate.setDistanceToBeam(distance -= dist);
        }
    }

    public boolean getIsBeamUpdated() {
        return this.isBeamUpdated;
    }

    public void setIsBeamUpdated(boolean update) {
        this.isBeamUpdated = update;
    }

    public static double calcBeamSimilarity(ArrayList beam, RowData data, boolean isNum) throws ClusException, InterruptedException {
        ArrayList<ArrayList<ClusStatistic>> predictions = new ArrayList<ArrayList<ClusStatistic>>();
        double result = 0.0;
        for (int i = 0; i < beam.size(); ++i) {
            try {
                ClusBeamModel model = (ClusBeamModel)beam.get(i);
                predictions.add(ClusBeamModelDistance.getPredictionsDataSet(model.getModel(), data, isNum));
                continue;
            }
            catch (ClassCastException e) {
                ClusModel model = (ClusModel)beam.get(i);
                predictions.add(ClusBeamModelDistance.getPredictionsDataSet(model, data, isNum));
            }
        }
        for (int m = 0; m < predictions.size(); ++m) {
            double dist = 0.0;
            for (int n = 0; n < predictions.size(); ++n) {
                dist += ClusBeamModelDistance.getDistance((ArrayList)predictions.get(m), (ArrayList)predictions.get(n));
            }
            dist = 1.0 - dist / (double)beam.size();
            result += dist;
        }
        return result / (double)beam.size();
    }

    public double getDistToConstraint(ClusBeamModel model, ClusBeamSyntacticConstraint constraint) {
        return 1.0 - ClusBeamModelDistance.getDistance(model.getModelPredictions(), constraint.getConstraintPredictions());
    }
}

