/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.io.Serializable;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ClusBeamModel
implements Comparable,
Serializable {
    public static final long serialVersionUID = 1L;
    protected transient int m_HashCode = -1;
    protected int m_ParentIndex;
    protected boolean m_Refined;
    protected boolean m_Finished;
    protected double m_Value;
    protected ClusModel m_Root;
    protected Object m_Refinement;
    protected double m_DistanceToBeam;
    protected ArrayList<ClusStatistic> m_Predictions;

    public ClusBeamModel() {
    }

    public ClusBeamModel(double value, ClusModel root) {
        this.m_Value = value;
        this.m_Root = root;
    }

    public void setValue(double value) {
        this.m_Value = value;
    }

    public double getValue() {
        return this.m_Value;
    }

    public ClusModel getModel() {
        return this.m_Root;
    }

    public void setModel(ClusNode root) {
        this.m_Root = root;
    }

    public Object getRefinement() {
        return this.m_Refinement;
    }

    public void setRefinement(Object refinement) {
        this.m_Refinement = refinement;
    }

    public String toString() {
        return "" + this.m_Value;
    }

    public final boolean isRefined() {
        return this.m_Refined;
    }

    public final void setRefined(boolean ref) {
        this.m_Refined = ref;
    }

    public final boolean isFinished() {
        return this.m_Finished;
    }

    public final void setFinished(boolean finish) {
        this.m_Finished = finish;
    }

    public void setParentModelIndex(int parent) {
        this.m_ParentIndex = parent;
    }

    public int getParentModelIndex() {
        return this.m_ParentIndex;
    }

    public int compareTo(Object e2) {
        ClusBeamModel m2 = (ClusBeamModel)e2;
        if (m2.m_Value != this.m_Value) {
            return m2.m_Value < this.m_Value ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        if (this.m_HashCode == -1) {
            this.m_HashCode = this.m_Root.hashCode();
            if (this.m_HashCode == -1) {
                this.m_HashCode = 0;
            }
        }
        return this.m_HashCode;
    }

    public boolean equals(Object other) {
        ClusBeamModel o = (ClusBeamModel)other;
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        return this.m_Root.equals(o.m_Root);
    }

    public ClusBeamModel cloneNoModel() {
        ClusBeamModel res = new ClusBeamModel();
        res.m_ParentIndex = this.m_ParentIndex;
        return res;
    }

    public ClusBeamModel cloneModel() {
        ClusBeamModel res = new ClusBeamModel();
        res.m_ParentIndex = this.m_ParentIndex;
        res.m_Root = this.m_Root;
        return res;
    }

    public void setDistanceToBeam(double distance) {
        this.m_DistanceToBeam = distance;
    }

    public double getDistanceToBeam() {
        return this.m_DistanceToBeam;
    }

    public void setModelPredictions(ArrayList<ClusStatistic> predictions) {
        this.m_Predictions = predictions;
    }

    public ArrayList<ClusStatistic> getModelPredictions() {
        return this.m_Predictions;
    }

    public ClusStatistic getPredictionForTuple(DataTuple tuple) {
        return this.m_Predictions.get(tuple.getIndex());
    }
}

