/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;

public class ClusBeamHeuristicMorishita
extends ClusBeamHeuristic {
    public ClusBeamHeuristicMorishita(ClusStatistic stat, Settings sett) {
        super(stat, sett);
    }

    public double computeMorishitaStat(ClusStatistic stat, ClusStatistic tstat) {
        RegressionStat stat_set = (RegressionStat)stat;
        RegressionStat stat_all = (RegressionStat)tstat;
        double result = 0.0;
        for (int i = 0; i < stat_set.getNbAttributes(); ++i) {
            double term_i = stat_set.getMean(i) - stat_all.getMean(i);
            result += term_i * term_i;
        }
        return result * stat_set.getTotalWeight();
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_tot = c_tstat.getTotalWeight();
        double n_pos = c_pstat.getTotalWeight();
        double n_neg = n_tot - n_pos;
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        this.m_Neg.copy(c_tstat);
        this.m_Neg.subtractFromThis(c_pstat);
        return this.computeMorishitaStat(c_pstat, c_tstat) + this.computeMorishitaStat(this.m_Neg, c_tstat);
    }

    public double estimateBeamMeasure(ClusNode tree, ClusNode parent) {
        if (tree.atBottomLevel()) {
            return this.computeMorishitaStat(tree.getClusteringStat(), parent.getClusteringStat());
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += this.estimateBeamMeasure(child);
        }
        return result;
    }

    @Override
    public double estimateBeamMeasure(ClusNode tree) {
        if (tree.atBottomLevel()) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < tree.getNbChildren(); ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            result += this.estimateBeamMeasure(child, tree);
        }
        return result;
    }

    @Override
    public double computeLeafAdd(ClusNode leaf) {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Beam Heuristic (Morishita)";
    }

    @Override
    public void setRootStatistic(ClusStatistic stat) {
        super.setRootStatistic(stat);
    }
}

