/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModelDistance;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamTreeElem;
import si.ijs.kt.clus.main.settings.section.SettingsBeamSearch;

public class ClusBeam {
    TreeMap m_Tree;
    Collection m_Values;
    int m_MaxWidth;
    int m_CrWidth;
    boolean m_RemoveEqualHeur;
    double m_MinValue = Double.NEGATIVE_INFINITY;
    double m_BeamSimilarity;

    public ClusBeam(int width, boolean rmEqHeur) {
        this.m_Tree = new TreeMap();
        this.m_Values = this.m_Tree.values();
        this.m_MaxWidth = width;
        this.m_RemoveEqualHeur = rmEqHeur;
    }

    public int addIfNotIn(ClusBeamModel model) {
        Double key = new Double(model.getValue());
        ClusBeamTreeElem found = (ClusBeamTreeElem)this.m_Tree.get(key);
        if (found == null) {
            this.m_Tree.put(key, new ClusBeamTreeElem(model));
            return 1;
        }
        if (this.m_RemoveEqualHeur) {
            found.setObject(model);
            return 0;
        }
        return found.addIfNotIn(model);
    }

    public void removeMin() {
        Object first_key = this.m_Tree.firstKey();
        ClusBeamTreeElem min_node = (ClusBeamTreeElem)this.m_Tree.get(first_key);
        if (min_node.hasList()) {
            min_node.removeFirst();
        } else {
            this.m_Tree.remove(first_key);
        }
    }

    public ClusBeamModel getBestAndSmallestModel() {
        ClusBeamTreeElem elem = (ClusBeamTreeElem)this.m_Tree.get(this.m_Tree.lastKey());
        if (elem.hasList()) {
            double value = Double.POSITIVE_INFINITY;
            ClusBeamModel result = null;
            ArrayList arr = elem.getOthers();
            for (int i = 0; i < arr.size(); ++i) {
                ClusBeamModel model = (ClusBeamModel)arr.get(i);
                int size = model.getModel().getModelSize();
                if (!((double)size < value)) continue;
                value = size;
                result = model;
            }
            return result;
        }
        return (ClusBeamModel)elem.getObject();
    }

    public ClusBeamModel getBestModel() {
        ClusBeamTreeElem elem = (ClusBeamTreeElem)this.m_Tree.get(this.m_Tree.lastKey());
        return (ClusBeamModel)elem.getAnObject();
    }

    public ClusBeamModel getWorstModel() {
        ClusBeamTreeElem elem = (ClusBeamTreeElem)this.m_Tree.get(this.m_Tree.firstKey());
        return (ClusBeamModel)elem.getAnObject();
    }

    public double computeMinValue() {
        return (Double)this.m_Tree.firstKey();
    }

    public void addModel(ClusBeamModel model) {
        double value = model.getValue();
        if (this.m_MaxWidth == -1) {
            this.m_CrWidth += this.addIfNotIn(model);
        } else if (this.m_CrWidth < this.m_MaxWidth) {
            this.m_CrWidth += this.addIfNotIn(model);
            if (this.m_CrWidth == this.m_MaxWidth) {
                this.m_MinValue = this.computeMinValue();
            }
        } else if (value >= this.m_MinValue && this.addIfNotIn(model) == 1) {
            double min;
            this.removeMin();
            this.m_MinValue = min = this.computeMinValue();
        }
    }

    public void print(PrintWriter wrt, int best_n) {
        ArrayList lst = this.toArray();
        for (int i = 0; i < Math.min(best_n, lst.size()); ++i) {
            if (i != 0) {
                wrt.println();
            }
            ClusBeamModel mdl = (ClusBeamModel)lst.get(lst.size() - i - 1);
            ClusNode tree = (ClusNode)mdl.getModel();
            double error = Double.NaN;
            wrt.println("Model: " + i + " value: " + mdl.getValue() + " error: " + error + " parent: " + mdl.getParentModelIndex());
            tree.printModel(wrt);
        }
    }

    public Iterator getIterator() {
        return this.m_Values.iterator();
    }

    public ArrayList toArray() {
        ArrayList lst = new ArrayList();
        for (ClusBeamTreeElem elem : this.m_Values) {
            elem.addAll(lst);
        }
        return lst;
    }

    public int getMaxWidth() {
        return this.m_MaxWidth;
    }

    public int getCrWidth() {
        return this.m_CrWidth;
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public void print() {
    }

    public int removeMinUpdated(ClusBeamModel candidate) {
        int bsize;
        if (this.m_CrWidth < this.m_MaxWidth) {
            this.m_CrWidth += this.addIfNotIn(candidate);
            return 1;
        }
        double candidateSimilarity = 1.0 - candidate.getDistanceToBeam() / (double)this.getCrWidth();
        double currentMin = candidate.getValue() - SettingsBeamSearch.BEAM_SIMILARITY * candidateSimilarity;
        ArrayList arr = this.toArray();
        int min_pos = bsize = arr.size();
        for (int i = 0; i < bsize; ++i) {
            double modelSimilarity = 1.0 - ((ClusBeamModel)arr.get(i)).getDistanceToBeam() / (double)this.getCrWidth();
            double modelUpdatedHeur = ((ClusBeamModel)arr.get(i)).getValue() - SettingsBeamSearch.BEAM_SIMILARITY * modelSimilarity;
            if (currentMin == modelUpdatedHeur && this.m_RemoveEqualHeur) {
                min_pos = bsize;
                break;
            }
            if (!(currentMin > modelUpdatedHeur)) continue;
            min_pos = i;
            currentMin = modelUpdatedHeur;
        }
        if (min_pos != bsize) {
            TreeMap<Double, ClusBeamTreeElem> temp = new TreeMap<Double, ClusBeamTreeElem>();
            for (int j = 0; j <= bsize; ++j) {
                if (j == min_pos) continue;
                ClusBeamModel cbm = j != bsize ? (ClusBeamModel)arr.get(j) : candidate;
                ClusBeamTreeElem found = (ClusBeamTreeElem)temp.get(cbm.getValue());
                if (found == null) {
                    temp.put(cbm.getValue(), new ClusBeamTreeElem(cbm));
                    continue;
                }
                found.addIfNotIn(cbm);
            }
            this.m_Tree = temp;
            this.m_Values = this.m_Tree.values();
            this.m_MinValue = this.computeMinValue();
            return 1;
        }
        return 0;
    }

    public int removeMinUpdatedOpt(ClusBeamModel candidate, ClusBeamModelDistance distance) {
        int bsize;
        if (this.m_CrWidth < this.m_MaxWidth) {
            this.m_CrWidth += this.addIfNotIn(candidate);
            return 1;
        }
        double candidateSimilarity = 1.0 - candidate.getDistanceToBeam() / (double)this.getCrWidth();
        double currentMin = candidate.getValue() - SettingsBeamSearch.BEAM_SIMILARITY * candidateSimilarity;
        ArrayList arr = this.toArray();
        int min_pos = bsize = arr.size();
        for (int i = 0; i < bsize; ++i) {
            double modelDistance = 1.0 - ((ClusBeamModel)arr.get(i)).getDistanceToBeam() / (double)this.getCrWidth();
            double modelUpdatedHeur = ((ClusBeamModel)arr.get(i)).getValue() - SettingsBeamSearch.BEAM_SIMILARITY * modelDistance;
            if (currentMin == modelUpdatedHeur && this.m_RemoveEqualHeur) {
                min_pos = bsize;
                break;
            }
            if (!(currentMin > modelUpdatedHeur)) continue;
            min_pos = i;
            currentMin = modelUpdatedHeur;
        }
        distance.deductFromBeamOpt(this, candidate, min_pos);
        if (min_pos != bsize) {
            TreeMap<Double, ClusBeamTreeElem> temp = new TreeMap<Double, ClusBeamTreeElem>();
            for (int j = 0; j <= bsize; ++j) {
                if (j == min_pos) continue;
                ClusBeamModel cbm = j != bsize ? (ClusBeamModel)arr.get(j) : candidate;
                ClusBeamTreeElem found = (ClusBeamTreeElem)temp.get(cbm.getValue());
                if (found == null) {
                    temp.put(cbm.getValue(), new ClusBeamTreeElem(cbm));
                    continue;
                }
                found.addIfNotIn(cbm);
            }
            this.m_Tree = temp;
            this.m_Values = this.m_Tree.values();
            this.m_MinValue = this.computeMinValue();
            return 1;
        }
        return 0;
    }

    public boolean modelAlreadyIn(ClusBeamModel model) {
        ArrayList arr = this.toArray();
        for (int k = 0; k < arr.size(); ++k) {
            ClusBeamModel bmodel = (ClusBeamModel)arr.get(k);
            if (!((ClusNode)bmodel.getModel()).equals(model.getModel())) continue;
            return true;
        }
        return false;
    }

    public void setBeamSimilarity(double similarity) {
        this.m_BeamSimilarity = similarity;
    }

    public double getBeamSimilarity() {
        return this.m_BeamSimilarity;
    }
}

