/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class RankingLoss
implements MlcHmlcSubError,
Serializable {
    private double m_NonnormalisedLoss = 0.0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return this.m_NonnormalisedLoss / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int i;
        final double[] scores = predicted;
        int wrongPairs = 0;
        int nbIrrelevant = 0;
        int nbRelevant = 0;
        ArrayList<Integer> indicesOfKnownValues = new ArrayList<Integer>();
        for (i = 0; i < actual.length; ++i) {
            indicesOfKnownValues.add(i);
        }
        Collections.sort(indicesOfKnownValues, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(scores[o1], scores[o2]);
            }
        });
        for (i = 0; i < indicesOfKnownValues.size(); ++i) {
            if (actual[(Integer)indicesOfKnownValues.get(i)]) {
                wrongPairs += nbIrrelevant;
                ++nbRelevant;
                continue;
            }
            ++nbIrrelevant;
        }
        if (nbRelevant > 0 && nbIrrelevant > 0) {
            this.m_NonnormalisedLoss += (double)wrongPairs / (double)(nbRelevant * nbIrrelevant);
        }
        ++this.m_NbKnown;
    }

    @Override
    public String getName() {
        return "RankingLoss";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        RankingLoss o = (RankingLoss)other;
        this.m_NonnormalisedLoss += o.m_NonnormalisedLoss;
        this.m_NbKnown += o.m_NbKnown;
    }
}

