/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.algo.kNN.KnnClassifier;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.error.mlcForHmlc.AveragePrecision;
import si.ijs.kt.clus.error.mlcForHmlc.Coverage;
import si.ijs.kt.clus.error.mlcForHmlc.HammingLoss;
import si.ijs.kt.clus.error.mlcForHmlc.MLAccuracy;
import si.ijs.kt.clus.error.mlcForHmlc.MLFOneMeasure;
import si.ijs.kt.clus.error.mlcForHmlc.MLPrecision;
import si.ijs.kt.clus.error.mlcForHmlc.MLRecall;
import si.ijs.kt.clus.error.mlcForHmlc.MLaverageAUPRC;
import si.ijs.kt.clus.error.mlcForHmlc.MLaverageAUROC;
import si.ijs.kt.clus.error.mlcForHmlc.MLpooledAUPRC;
import si.ijs.kt.clus.error.mlcForHmlc.MLweightedAUPRC;
import si.ijs.kt.clus.error.mlcForHmlc.MacroFOne;
import si.ijs.kt.clus.error.mlcForHmlc.MacroPrecision;
import si.ijs.kt.clus.error.mlcForHmlc.MacroRecall;
import si.ijs.kt.clus.error.mlcForHmlc.MicroFOne;
import si.ijs.kt.clus.error.mlcForHmlc.MicroPrecision;
import si.ijs.kt.clus.error.mlcForHmlc.MicroRecall;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.error.mlcForHmlc.OneError;
import si.ijs.kt.clus.error.mlcForHmlc.RankingLoss;
import si.ijs.kt.clus.error.mlcForHmlc.SubsetAccuracy;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class MlcMeasuresForHmlc
extends ClusError {
    public static final long serialVersionUID = 1L;
    private static final double MAJORITY_PROPORTION = 0.5;
    protected ClassHierarchy m_Hier;
    protected boolean[] m_EvalClass;
    private int m_DimEval;
    private ArrayList<MlcHmlcSubError> m_SubErrors;
    private double[] m_ComputedErrors;

    public MlcMeasuresForHmlc(ClusErrorList par, ClassHierarchy hier) throws ClusException {
        super(par, hier.getTotal());
        this.m_Hier = hier;
        this.m_EvalClass = hier.getEvalClassesVector();
        this.m_DimEval = 0;
        for (boolean shouldEval : this.m_EvalClass) {
            this.m_DimEval += shouldEval ? 1 : 0;
        }
        if (this.m_DimEval == 0) {
            throw new ClusException("MLC measures: Number of dimensions to evaluate is zero.");
        }
        this.m_SubErrors = new ArrayList();
        this.m_SubErrors.add(new HammingLoss());
        this.m_SubErrors.add(new AveragePrecision());
        this.m_SubErrors.add(new Coverage());
        this.m_SubErrors.add(new MacroFOne(this.m_DimEval));
        this.m_SubErrors.add(new MacroPrecision(this.m_DimEval));
        this.m_SubErrors.add(new MacroRecall(this.m_DimEval));
        this.m_SubErrors.add(new MicroFOne(this.m_DimEval));
        this.m_SubErrors.add(new MicroPrecision(this.m_DimEval));
        this.m_SubErrors.add(new MicroRecall(this.m_DimEval));
        this.m_SubErrors.add(new MLAccuracy());
        this.m_SubErrors.add(new MLFOneMeasure());
        this.m_SubErrors.add(new MLPrecision());
        this.m_SubErrors.add(new MLRecall());
        this.m_SubErrors.add(new OneError());
        this.m_SubErrors.add(new RankingLoss());
        this.m_SubErrors.add(new SubsetAccuracy());
        this.m_SubErrors.add(new MLaverageAUPRC(this.m_DimEval));
        this.m_SubErrors.add(new MLaverageAUROC(this.m_DimEval));
        this.m_SubErrors.add(new MLpooledAUPRC(this.m_DimEval));
        this.m_SubErrors.add(new MLweightedAUPRC(this.m_DimEval));
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(this.m_Hier.getType().getArrayIndex());
        boolean[] actual = tp.getVectorBooleanNodeAndAncestors(this.m_Hier);
        double[] predicted = ((WHTDStatistic)pred).getNumericPred();
        double[] thresholds = ((WHTDStatistic)pred).getThresholds();
        boolean[] actualFiltered = new boolean[this.m_DimEval];
        double[] predictedFiltered = new double[this.m_DimEval];
        boolean[] predictedThresholdedFiltered = new boolean[this.m_DimEval];
        int index = 0;
        for (int i = 0; i < predicted.length; ++i) {
            if (!this.m_EvalClass[i]) continue;
            actualFiltered[index] = actual[i];
            predictedFiltered[index] = predicted[i];
            double threshold = thresholds == null ? 0.5 : thresholds[i];
            predictedThresholdedFiltered[index] = predicted[i] >= threshold;
            ++index;
        }
        this.updateAll(actualFiltered, predictedFiltered, predictedThresholdedFiltered);
    }

    public void updateAll(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        for (MlcHmlcSubError suberror : this.m_SubErrors) {
            suberror.addExample(actual, predicted, predictedThresholded);
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public boolean isComputeForModel(String name) {
        if (name.equals("Original") || name.equals("Pruned") || name.equals("Default")) {
            return true;
        }
        if (name.startsWith("Original ") && name.contains("-nn model with ") || name.equals(KnnClassifier.DEFAULT_MODEL_NAME_WITH_CONSTANT_WEIGHTS)) {
            return true;
        }
        return name.startsWith("Forest with ") && !name.contains("T = ");
    }

    @Override
    public boolean shouldBeLow() {
        System.err.println("MlcMeasuresForHmlc are sometimes desired to be low and sometimes not. Will return false");
        return false;
    }

    @Override
    public double getModelError() {
        throw new RuntimeException("This call has no sense!");
    }

    public boolean isEvalClass(int idx) {
        return this.m_EvalClass[idx];
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    public void computeAll() {
        int n = this.m_SubErrors.size();
        this.m_ComputedErrors = new double[n];
        for (int i = 0; i < n; ++i) {
            this.m_ComputedErrors[i] = this.m_SubErrors.get(i).getModelError(this.m_DimEval);
        }
    }

    @Override
    public void showModelError(PrintWriter out, String bName, int detail) throws IOException {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        int maxLength = 0;
        for (MlcHmlcSubError suberror : this.m_SubErrors) {
            maxLength = Math.max(maxLength, suberror.getName().length());
        }
        String formater = String.format("      %%-%ds %%s%%s", 9 + maxLength);
        this.computeAll();
        out.println();
        for (int i = 0; i < this.m_ComputedErrors.length; ++i) {
            String components = "";
            if (this.m_SubErrors.get(i) instanceof ComponentError) {
                Object[] componentErrors = new String[this.m_DimEval];
                for (int comp = 0; comp < this.m_DimEval; ++comp) {
                    componentErrors[comp] = fr.format(((ComponentError)((Object)this.m_SubErrors.get(i))).getModelErrorComponent(comp));
                }
                components = String.format("%s: ", Arrays.toString(componentErrors));
            }
            out.println(String.format(formater, this.m_SubErrors.get(i).getName() + ":", components, fr.format(this.m_ComputedErrors[i])));
        }
    }

    @Override
    public String getName() {
        return "Multilabel error measures for HMLC";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) throws ClusException {
        return new MlcMeasuresForHmlc(par, this.m_Hier);
    }

    @Override
    public void add(ClusError other) {
        if (other instanceof MlcMeasuresForHmlc) {
            MlcMeasuresForHmlc o = (MlcMeasuresForHmlc)other;
            for (int i = 0; i < o.m_SubErrors.size(); ++i) {
                MlcHmlcSubError your = o.m_SubErrors.get(i);
                MlcHmlcSubError my = this.m_SubErrors.get(i);
                if (your == null) continue;
                my.add(your);
            }
        } else {
            super.add(other);
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        try {
            this.showModelError(out, null, detail);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

