/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MicroRecall
implements MlcHmlcSubError,
Serializable {
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalseNegatives;

    public MicroRecall(int dim) {
        this.m_NbTruePositives = new int[dim];
        this.m_NbFalseNegatives = new int[dim];
    }

    @Override
    public double getModelError(int dim) {
        int truePositives = 0;
        int falseNegatives = 0;
        for (int i = 0; i < dim; ++i) {
            truePositives += this.m_NbTruePositives[i];
            falseNegatives += this.m_NbFalseNegatives[i];
        }
        if (ClusUtil.isZero(truePositives + falseNegatives)) {
            return Double.NaN;
        }
        return (double)truePositives / (double)(truePositives + falseNegatives);
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        for (int i = 0; i < actual.length; ++i) {
            if (!actual[i]) continue;
            if (predictedThresholded[i]) {
                int n = i;
                this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                continue;
            }
            int n = i;
            this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
        }
    }

    @Override
    public String getName() {
        return "MicroRecall";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MicroRecall o = (MicroRecall)other;
        for (int i = 0; i < this.m_NbTruePositives.length; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + o.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalseNegatives[n2] = this.m_NbFalseNegatives[n2] + o.m_NbFalseNegatives[i];
        }
    }
}

