/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MacroRecall
implements ComponentError,
MlcHmlcSubError,
Serializable {
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalseNegatives;

    public MacroRecall(int dim) {
        this.m_NbTruePositives = new int[dim];
        this.m_NbFalseNegatives = new int[dim];
    }

    @Override
    public double getModelError(int dim) {
        double avg = 0.0;
        for (int i = 0; i < dim; ++i) {
            avg += this.getModelErrorComponent(i);
        }
        return avg / (double)dim;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int dim = actual.length;
        for (int i = 0; i < dim; ++i) {
            if (!actual[i]) continue;
            if (predictedThresholded[i]) {
                int n = i;
                this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                continue;
            }
            int n = i;
            this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
        }
    }

    @Override
    public String getName() {
        return "MacroRecall";
    }

    @Override
    public double getModelErrorComponent(int i) {
        if (ClusUtil.isNaNOrZero(this.m_NbTruePositives[i] + this.m_NbFalseNegatives[i])) {
            return Double.NaN;
        }
        return (double)this.m_NbTruePositives[i] / (double)(this.m_NbTruePositives[i] + this.m_NbFalseNegatives[i]);
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MacroRecall o = (MacroRecall)other;
        for (int i = 0; i < this.m_NbTruePositives.length; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + o.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalseNegatives[n2] = this.m_NbFalseNegatives[n2] + o.m_NbFalseNegatives[i];
        }
    }
}

