/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MacroFOne
implements MlcHmlcSubError,
ComponentError,
Serializable {
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalsePositives;
    protected int[] m_NbFalseNegatives;

    public MacroFOne(int dim) {
        this.m_NbTruePositives = new int[dim];
        this.m_NbFalsePositives = new int[dim];
        this.m_NbFalseNegatives = new int[dim];
    }

    @Override
    public double getModelError(int dim) {
        double avg = 0.0;
        for (int i = 0; i < dim; ++i) {
            avg += this.getModelErrorComponent(i);
        }
        return avg / (double)dim;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int dim = predictedThresholded.length;
        for (int i = 0; i < dim; ++i) {
            if (actual[i]) {
                if (predictedThresholded[i]) {
                    int n = i;
                    this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                    continue;
                }
                int n = i;
                this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
                continue;
            }
            if (!predictedThresholded[i]) continue;
            int n = i;
            this.m_NbFalsePositives[n] = this.m_NbFalsePositives[n] + 1;
        }
    }

    @Override
    public String getName() {
        return "MacroFOne";
    }

    @Override
    public double getModelErrorComponent(int i) {
        double prec = (double)this.m_NbTruePositives[i] / (double)(this.m_NbTruePositives[i] + this.m_NbFalsePositives[i]);
        double recall = (double)this.m_NbTruePositives[i] / (double)(this.m_NbTruePositives[i] + this.m_NbFalseNegatives[i]);
        prec = ClusUtil.isNaNOrZero(prec) ? Double.NaN : prec;
        double d = recall = ClusUtil.isNaNOrZero(recall) ? Double.NaN : recall;
        if (ClusUtil.isNaNOrZero(prec + recall)) {
            return Double.NaN;
        }
        return 2.0 * prec * recall / (prec + recall);
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MacroFOne o = (MacroFOne)other;
        for (int i = 0; i < this.m_NbTruePositives.length; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + o.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalsePositives[n2] = this.m_NbFalsePositives[n2] + o.m_NbFalsePositives[i];
            int n3 = i;
            this.m_NbFalseNegatives[n3] = this.m_NbFalseNegatives[n3] + o.m_NbFalseNegatives[i];
        }
    }
}

