/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MLRecall
implements MlcHmlcSubError,
Serializable {
    private double m_RecallSum = 0.0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return this.m_RecallSum / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int intersection = 0;
        int nbRelevant = 0;
        int nbRelevantPredicted = 0;
        for (int i = 0; i < actual.length; ++i) {
            if (actual[i]) {
                ++nbRelevant;
                if (predictedThresholded[i]) {
                    ++intersection;
                }
            }
            if (!predictedThresholded[i]) continue;
            ++nbRelevantPredicted;
        }
        this.m_RecallSum += nbRelevant != 0 ? (double)intersection / (double)nbRelevant : (nbRelevantPredicted == 0 ? 1.0 : 0.0);
        ++this.m_NbKnown;
    }

    @Override
    public String getName() {
        return "MLRecall";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MLRecall o = (MLRecall)other;
        this.m_RecallSum += o.m_RecallSum;
        this.m_NbKnown += o.m_NbKnown;
    }
}

