/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MLPrecision
implements MlcHmlcSubError,
Serializable {
    private double m_PrecisionSum = 0.0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return this.m_PrecisionSum / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int intersection = 0;
        int nbRelevant = 0;
        int nbRelevantPredicted = 0;
        for (int i = 0; i < actual.length; ++i) {
            if (predictedThresholded[i]) {
                ++nbRelevantPredicted;
                if (actual[i]) {
                    ++intersection;
                }
            }
            if (!actual[i]) continue;
            ++nbRelevant;
        }
        this.m_PrecisionSum += nbRelevantPredicted != 0 ? (double)intersection / (double)nbRelevantPredicted : (nbRelevant == 0 ? 1.0 : 0.0);
        ++this.m_NbKnown;
    }

    @Override
    public String getName() {
        return "MLPrecision";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MLPrecision o = (MLPrecision)other;
        this.m_PrecisionSum += o.m_PrecisionSum;
        this.m_NbKnown += o.m_NbKnown;
    }
}

