/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class MLAccuracy
implements MlcHmlcSubError,
Serializable {
    private double m_JaccardSum = 0.0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return this.m_JaccardSum / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        int intersection = 0;
        int union = 0;
        for (int i = 0; i < actual.length; ++i) {
            if (actual[i] && predictedThresholded[i]) {
                ++union;
                ++intersection;
                continue;
            }
            if (!actual[i] && !predictedThresholded[i]) continue;
            ++union;
        }
        this.m_JaccardSum += union != 0 ? (double)intersection / (double)union : 1.0;
        ++this.m_NbKnown;
    }

    @Override
    public String getName() {
        return "MLAccuracy";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        MLAccuracy o = (MLAccuracy)other;
        this.m_JaccardSum += o.m_JaccardSum;
        this.m_NbKnown += o.m_NbKnown;
    }
}

