/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class HammingLoss
implements MlcHmlcSubError,
Serializable {
    private int m_NbWrong = 0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dimensions) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return (double)this.m_NbWrong / (double)this.m_NbKnown / (double)dimensions;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        for (int i = 0; i < actual.length; ++i) {
            if (actual[i] == predictedThresholded[i]) continue;
            ++this.m_NbWrong;
        }
        ++this.m_NbKnown;
    }

    @Override
    public String getName() {
        return "HammingLoss";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        this.m_NbWrong += ((HammingLoss)other).m_NbWrong;
        this.m_NbKnown += ((HammingLoss)other).m_NbKnown;
    }
}

