/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlcForHmlc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import si.ijs.kt.clus.error.mlcForHmlc.MlcHmlcSubError;
import si.ijs.kt.clus.util.ClusUtil;

public class AveragePrecision
implements MlcHmlcSubError,
Serializable {
    private double m_NonnormalisedPrec = 0.0;
    private int m_NbKnown = 0;

    @Override
    public double getModelError(int dim) {
        if (ClusUtil.isZero(this.m_NbKnown)) {
            return Double.NaN;
        }
        return this.m_NonnormalisedPrec / (double)this.m_NbKnown;
    }

    @Override
    public void addExample(boolean[] actual, double[] predicted, boolean[] predictedThresholded) {
        final double[] scores = predicted;
        int dim = scores.length;
        boolean[] isRelevant = actual;
        ArrayList<Integer> indicesOfKnownValues = new ArrayList<Integer>();
        for (int i = 0; i < dim; ++i) {
            indicesOfKnownValues.add(i);
        }
        Collections.sort(indicesOfKnownValues, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(scores[o1], scores[o2]);
            }
        });
        int nbOfRelevant = 0;
        double u = 0.0;
        if (indicesOfKnownValues.size() > 0) {
            for (int i = 0; i < indicesOfKnownValues.size(); ++i) {
                if (!isRelevant[(Integer)indicesOfKnownValues.get(i)]) continue;
                u += (double)(++nbOfRelevant) / (double)(i + 1);
            }
            this.m_NonnormalisedPrec += u / (double)nbOfRelevant;
            ++this.m_NbKnown;
        }
    }

    @Override
    public String getName() {
        return "AveragePrecision";
    }

    @Override
    public void add(MlcHmlcSubError other) {
        this.m_NonnormalisedPrec += ((AveragePrecision)other).m_NonnormalisedPrec;
        this.m_NbKnown += ((AveragePrecision)other).m_NbKnown;
    }
}

