/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class RankingLoss
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected double m_NonnormalisedLoss = 0.0;
    protected int m_NbKnown = 0;

    public RankingLoss(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public void reset() {
        this.m_NonnormalisedLoss = 0.0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        RankingLoss rl = (RankingLoss)other;
        this.m_NonnormalisedLoss += rl.m_NonnormalisedLoss;
        this.m_NbKnown += rl.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return this.m_NonnormalisedLoss / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "RankingLoss";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new RankingLoss(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        NominalAttrType attr;
        int i;
        final double[] scores = ((ClassificationStat)pred).calcScores();
        int wrongPairs = 0;
        int nbIrrelevant = 0;
        int nbRelevant = 0;
        ArrayList<Integer> indicesOfKnownValues = new ArrayList<Integer>();
        for (i = 0; i < this.m_Dim; ++i) {
            attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            indicesOfKnownValues.add(i);
        }
        Collections.sort(indicesOfKnownValues, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(scores[o1], scores[o2]);
            }
        });
        for (i = 0; i < indicesOfKnownValues.size(); ++i) {
            attr = this.getAttr((Integer)indicesOfKnownValues.get(i));
            if (attr.getNominal(tuple) == 0) {
                wrongPairs += nbIrrelevant;
                ++nbRelevant;
                continue;
            }
            ++nbIrrelevant;
        }
        if (nbRelevant > 0 && nbIrrelevant > 0) {
            this.m_NonnormalisedLoss += (double)wrongPairs / (double)(nbRelevant * nbIrrelevant);
        }
        ++this.m_NbKnown;
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        try {
            throw new Exception("RankingLoss.addExample(DataTuple tuple, DataTuple pred) cannot be implemented.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

