/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class OneError
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int m_NbWrong = 0;
    protected int m_NbKnown = 0;

    public OneError(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public void reset() {
        this.m_NbWrong = 0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        OneError oe = (OneError)other;
        this.m_NbWrong += oe.m_NbWrong;
        this.m_NbKnown += oe.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return (double)this.m_NbWrong / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "OneError";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new OneError(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        NominalAttrType attr;
        int[] predicted = pred.getNominalPred();
        double[] scores = ((ClassificationStat)pred).calcScores();
        int maxScoreLabel = -1;
        double maxScore = -1.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            attr = this.getAttr(i);
            if (attr.isMissing(tuple) || !(scores[i] > maxScore)) continue;
            maxScoreLabel = i;
            maxScore = scores[i];
        }
        if (maxScoreLabel >= 0) {
            attr = this.getAttr(maxScoreLabel);
            if (attr.getNominal(tuple) != predicted[maxScoreLabel]) {
                ++this.m_NbWrong;
            }
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        try {
            throw new Exception("OneError.addExample(DataTuple tuple, DataTuple pred) cannot be implemented.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

