/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class MacroRecall
extends ClusNominalError
implements ComponentError {
    public static final long serialVersionUID = 1L;
    protected int[] m_NbTruePositives;
    protected int[] m_NbFalseNegatives;

    public MacroRecall(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
        this.m_NbTruePositives = new int[this.m_Dim];
        this.m_NbFalseNegatives = new int[this.m_Dim];
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        Arrays.fill(this.m_NbTruePositives, 0);
        Arrays.fill(this.m_NbFalseNegatives, 0);
    }

    @Override
    public void add(ClusError other) {
        MacroRecall mr = (MacroRecall)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + mr.m_NbTruePositives[i];
            int n2 = i;
            this.m_NbFalseNegatives[n2] = this.m_NbFalseNegatives[n2] + mr.m_NbFalseNegatives[i];
        }
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    public double getMacroRecall(int i) {
        return this.getModelErrorComponent(i);
    }

    @Override
    public double getModelErrorComponent(int i) {
        return (double)this.m_NbTruePositives[i] / (double)(this.m_NbTruePositives[i] + this.m_NbFalseNegatives[i]);
    }

    @Override
    public double getModelError() {
        double avg = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            avg += this.getModelErrorComponent(i);
        }
        return avg / (double)this.m_Dim;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        Object[] componentErrors = new String[this.m_Dim];
        for (int i = 0; i < this.m_Dim; ++i) {
            componentErrors[i] = ClusFormat.FOUR_AFTER_DOT.format(this.getModelErrorComponent(i));
        }
        out.println(String.format("%s: %s", Arrays.toString(componentErrors), ClusFormat.FOUR_AFTER_DOT.format(this.getModelError())));
    }

    @Override
    public String getName() {
        return "MacroRecall";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MacroRecall(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple) || attr.getNominal(tuple) != 0) continue;
            if (predicted[i] == 0) {
                int n = i;
                this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                continue;
            }
            int n = i;
            this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple) || attr.getNominal(tuple) != 0) continue;
            if (attr.getNominal(pred) == 0) {
                int n = i;
                this.m_NbTruePositives[n] = this.m_NbTruePositives[n] + 1;
                continue;
            }
            int n = i;
            this.m_NbFalseNegatives[n] = this.m_NbFalseNegatives[n] + 1;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

