/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class MLRecall
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected double m_RecallSum = 0.0;
    protected int m_NbKnown = 0;

    public MLRecall(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        this.m_RecallSum = 0.0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        MLRecall mlcp = (MLRecall)other;
        this.m_RecallSum += mlcp.m_RecallSum;
        this.m_NbKnown += mlcp.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return this.m_RecallSum / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "MLRecall";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MLRecall(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        int intersection = 0;
        int nbRelevant = 0;
        int nbRelevantPredicted = 0;
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == 0) {
                ++nbRelevant;
                if (predicted[i] == 0) {
                    ++intersection;
                }
            }
            if (predicted[i] != 0) continue;
            ++nbRelevantPredicted;
        }
        if (atLeastOneKnown) {
            this.m_RecallSum += nbRelevant != 0 ? (double)intersection / (double)nbRelevant : (nbRelevantPredicted == 0 ? 1.0 : 0.0);
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        int intersection = 0;
        int nbRelevant = 0;
        int nbRelevantPredicted = 0;
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == 0) {
                ++nbRelevant;
                if (attr.getNominal(pred) == 0) {
                    ++intersection;
                }
            }
            if (attr.getNominal(pred) != 0) continue;
            ++nbRelevantPredicted;
        }
        if (atLeastOneKnown) {
            this.m_RecallSum += nbRelevant != 0 ? (double)intersection / (double)nbRelevant : (nbRelevantPredicted == 0 ? 1.0 : 0.0);
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

