/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class MLAccuracy
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected double m_JaccardSum = 0.0;
    protected int m_NbKnown = 0;

    public MLAccuracy(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        this.m_JaccardSum = 0.0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        MLAccuracy mlca = (MLAccuracy)other;
        this.m_JaccardSum += mlca.m_JaccardSum;
        this.m_NbKnown += mlca.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return this.m_JaccardSum / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "MLAccuracy";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new MLAccuracy(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        int intersection = 0;
        int union = 0;
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == 0 && predicted[i] == 0) {
                ++union;
                ++intersection;
                continue;
            }
            if (attr.getNominal(tuple) == 1 && predicted[i] == 1) continue;
            ++union;
        }
        if (atLeastOneKnown) {
            this.m_JaccardSum += union != 0 ? (double)intersection / (double)union : 1.0;
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        int intersection = 0;
        int union = 0;
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == 0 && attr.getNominal(pred) == 0) {
                ++union;
                ++intersection;
                continue;
            }
            if (attr.getNominal(tuple) == 1 && attr.getNominal(pred) == 1) continue;
            ++union;
        }
        if (atLeastOneKnown) {
            this.m_JaccardSum += union != 0 ? (double)intersection / (double)union : 1.0;
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

