/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.mlc;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;

public class HammingLoss
extends ClusNominalError {
    public static final long serialVersionUID = 1L;
    protected int m_NbWrong = 0;
    protected int m_NbKnown = 0;

    public HammingLoss(ClusErrorList par, NominalAttrType[] nom) {
        super(par, nom);
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }

    @Override
    public void reset() {
        this.m_NbWrong = 0;
        this.m_NbKnown = 0;
    }

    @Override
    public void add(ClusError other) {
        HammingLoss ham = (HammingLoss)other;
        this.m_NbWrong += ham.m_NbWrong;
        this.m_NbKnown += ham.m_NbKnown;
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    @Override
    public double getModelError() {
        return (double)this.m_NbWrong / (double)this.m_Dim / (double)this.m_NbKnown;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(ClusFormat.FOUR_AFTER_DOT.format(this.getModelError()));
    }

    @Override
    public String getName() {
        return "HammingLoss";
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new HammingLoss(par, this.m_Attrs);
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == predicted[i]) continue;
            ++this.m_NbWrong;
        }
        if (atLeastOneKnown) {
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        boolean atLeastOneKnown = false;
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            atLeastOneKnown = true;
            if (attr.getNominal(tuple) == attr.getNominal(pred)) continue;
            ++this.m_NbWrong;
        }
        if (atLeastOneKnown) {
            ++this.m_NbKnown;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

