/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.hmlc;

import java.util.Arrays;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.WHTDStatistic;

public class HierRMSError
extends MSError {
    public static final long serialVersionUID = 1L;
    protected ClassHierarchy m_Hier;
    protected double[] m_Scratch;
    protected boolean m_Root;
    protected boolean m_ContPred;

    public HierRMSError(ClusErrorList par, ClusAttributeWeights weights, boolean root, boolean proto, ClassHierarchy hier) {
        this(par, weights, false, root, proto, hier);
    }

    public HierRMSError(ClusErrorList par, ClusAttributeWeights weights, boolean printall, boolean root, boolean proto, ClassHierarchy hier) {
        super(par, hier.getDummyAttrs(), weights, printall, "");
        this.m_Hier = hier;
        this.m_Root = root;
        this.m_ContPred = proto;
        this.m_Scratch = new double[this.m_Dim];
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        if (pred == null) {
            return;
        }
        ClassesTuple tp = (ClassesTuple)tuple.getObjVal(0);
        Arrays.fill(this.m_Scratch, 0.0);
        for (int i = 0; i < tp.getNbClasses(); ++i) {
            ClassesValue val = tp.getClass(i);
            this.m_Scratch[val.getIndex()] = 1.0;
        }
        if (this.m_ContPred) {
            this.addExample(this.m_Scratch, pred.getNumericPred());
        } else {
            this.addExample(this.m_Scratch, ((WHTDStatistic)pred).getDiscretePred());
        }
    }

    @Override
    public double getModelError() {
        if (this.m_Root) {
            return Math.sqrt(super.getModelError());
        }
        return super.getModelError();
    }

    @Override
    public double getModelErrorComponent(int i) {
        if (this.m_Root) {
            return Math.sqrt(super.getModelErrorComponent(i));
        }
        return super.getModelErrorComponent(i);
    }

    @Override
    public String getName() {
        String proto;
        String root = this.m_Root ? "RMSE" : "MSE";
        String string = proto = this.m_ContPred ? "with continuous predictions" : "with discrete predictions";
        if (this.m_Weights == null) {
            return "Hierarchical " + root + " " + proto;
        }
        return "Hierarchical weighted " + root + " (" + this.m_Weights.getName() + ") " + proto;
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new HierRMSError(par, this.m_Weights, this.m_PrintAllComps, this.m_Root, this.m_ContPred, this.m_Hier);
    }
}

