/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error.common.multiscore;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class MultiScoreWrapper
extends ClusNumericError {
    public static final long serialVersionUID = 1L;
    protected ClusNominalError m_Child;
    protected byte[] m_Real;
    protected int[] m_Pred;

    public MultiScoreWrapper(ClusNominalError child, NumericAttrType[] num) {
        super(child.getParent(), num);
        int dim = this.getDimension();
        this.m_Real = new byte[dim];
        this.m_Pred = new int[dim];
        this.m_Child = child;
    }

    @Override
    public boolean shouldBeLow() {
        return this.m_Child.shouldBeLow();
    }

    @Override
    public void reset() {
        this.m_Child.reset();
    }

    @Override
    public double getModelError() {
        return this.m_Child.getModelError();
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        for (int i = 0; i < this.m_Real.length; ++i) {
            this.m_Real[i] = (byte)(!(real[i] > 0.5) ? 1 : 0);
            this.m_Pred[i] = predicted[i] > 0.5 ? 0 : 1;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        for (int i = 0; i < this.m_Dim; ++i) {
        }
    }

    @Override
    public void add(ClusError other) {
        MultiScoreWrapper oe = (MultiScoreWrapper)other;
        this.m_Child.add(oe.m_Child);
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        this.m_Child.showModelError(out, detail);
    }

    @Override
    public String getName() {
        return this.m_Child.getName();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) throws ClusException {
        return new MultiScoreWrapper((ClusNominalError)this.m_Child.getErrorClone(par), this.m_Attrs);
    }
}

