/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;

public class WAHNDError
extends ClusError {
    public static final long serialVersionUID = 1L;
    protected double m_Weight;
    protected double m_TreeErr;
    protected double m_SumWeight;

    public WAHNDError(ClusErrorList par, double weight) {
        this(par, weight, "");
    }

    public WAHNDError(ClusErrorList par, double weight, String info) {
        super(par, 0);
        this.m_Weight = weight;
        this.setAdditionalInfo(info);
    }

    @Override
    public void add(ClusError other) {
        WAHNDError err = (WAHNDError)other;
        this.m_TreeErr += err.m_TreeErr;
        this.m_SumWeight += err.m_SumWeight;
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        out.println(this.m_TreeErr / this.m_SumWeight);
    }

    public void addExample(ClusData data, int idx, ClusStatistic pred) {
        ClusLogger.info("WAHNDError: addExample/3 not implemented");
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        double weight = tuple.getWeight();
        this.m_SumWeight += weight;
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public double getModelError() {
        return this.m_TreeErr / this.m_SumWeight;
    }

    @Override
    public void reset() {
        this.m_TreeErr = 0.0;
        this.m_SumWeight = 0.0;
    }

    @Override
    public String getName() {
        return "WAHND RE with parameter " + this.m_Weight + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new WAHNDError(par, this.m_Weight, this.getAdditionalInfo());
    }

    @Override
    public boolean shouldBeLow() {
        throw new RuntimeException("should WAHNDError be high or low?");
    }
}

