/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.util.ClusUtil;

public class SpearmanRankCorrelationPerExample
extends ClusNumericError {
    private static final long serialVersionUID = 1L;
    protected ArrayList<Double> RankCorrelations = new ArrayList();

    public SpearmanRankCorrelationPerExample(ClusErrorList par, NumericAttrType[] num) {
        this(par, num, "");
    }

    public SpearmanRankCorrelationPerExample(ClusErrorList par, NumericAttrType[] num, String info) {
        super(par, num);
        this.setAdditionalInfo(info);
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        double rank = this.getSpearmanRankCorrelation(real, predicted);
        this.RankCorrelations.add(rank);
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) {
        double[] double_real = new double[this.m_Dim];
        double[] double_pred = new double[this.m_Dim];
        for (int i = 0; i < this.m_Dim; ++i) {
            double_real[i] = this.getAttr(i).getNumeric(real);
            double_pred[i] = this.getAttr(i).getNumeric(pred);
        }
        this.addExample(double_real, double_pred);
    }

    @Override
    public double getModelErrorComponent(int i) {
        throw new RuntimeException("SpearmanRankCorrelationPerExample does not have multiple components (it's a measure over all dimensions)");
    }

    public double getAvgRankCorr() {
        double total = 0.0;
        for (int i = 0; i < this.RankCorrelations.size(); ++i) {
            total += this.RankCorrelations.get(i).doubleValue();
        }
        return total / (double)this.RankCorrelations.size();
    }

    public double getHarmonicAvgRankCorr() {
        double total = 0.0;
        for (int i = 0; i < this.RankCorrelations.size(); ++i) {
            total += 1.0 / this.RankCorrelations.get(i);
        }
        return (double)this.RankCorrelations.size() / total;
    }

    public double getRankCorrVariance() {
        double avg = this.getAvgRankCorr();
        double total = 0.0;
        for (int i = 0; i < this.RankCorrelations.size(); ++i) {
            total += (this.RankCorrelations.get(i) - avg) * (this.RankCorrelations.get(i) - avg);
        }
        return total / (double)this.RankCorrelations.size();
    }

    public double getHarmonicRankCorrVariance() {
        double avg = this.getHarmonicAvgRankCorr();
        double total = 0.0;
        for (int i = 0; i < this.RankCorrelations.size(); ++i) {
            total += (this.RankCorrelations.get(i) - avg) * (this.RankCorrelations.get(i) - avg);
        }
        return total / (double)this.RankCorrelations.size();
    }

    @Override
    public String getName() {
        return "Spearman Rank Correlation" + this.getAdditionalInfoFormatted();
    }

    public double getSpearmanRankCorrelation(double[] a, double[] b) {
        int n = a.length;
        double[] ra = ClusUtil.getRanks(a);
        double[] rb = ClusUtil.getRanks(b);
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = ra[i] - rb[i];
        }
        double sum_ds = 0.0;
        for (int i = 0; i < n; ++i) {
            sum_ds += d[i] * d[i];
        }
        double rank = 1.0 - 6.0 * sum_ds / (double)(n * (n * n - 1));
        return rank;
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return null;
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }
}

