/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;

public class RelativeError
extends ClusNumericError
implements ComponentError {
    private static final long serialVersionUID = 1L;
    protected double[] m_SumRelErr;

    public RelativeError(ClusErrorList par, NumericAttrType[] num) {
        this(par, num, "");
    }

    public RelativeError(ClusErrorList par, NumericAttrType[] num, String info) {
        this(par, num, null, true);
        this.m_SumRelErr = new double[this.m_Dim];
    }

    public RelativeError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights) {
        this(par, num, weights, true);
        this.m_SumRelErr = new double[this.m_Dim];
    }

    public RelativeError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, boolean printall) {
        this(par, num, weights, printall, "");
    }

    public RelativeError(ClusErrorList par, NumericAttrType[] num, ClusAttributeWeights weights, boolean printall, String info) {
        super(par, num);
        this.m_SumRelErr = new double[this.m_Dim];
        this.setAdditionalInfo(info);
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        int i = 0;
        while (i < this.m_Dim) {
            double err = (real[i] - predicted[i]) / real[i];
            int n = i++;
            this.m_SumRelErr[n] = this.m_SumRelErr[n] + err;
        }
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        double[] predicted = pred.getNumericPred();
        int i = 0;
        while (i < this.m_Dim) {
            double err = Math.abs(this.getAttr(i).getNumeric(tuple) - predicted[i]) / this.getAttr(i).getNumeric(tuple);
            int n = i++;
            this.m_SumRelErr[n] = this.m_SumRelErr[n] + err;
        }
    }

    @Override
    public void addExample(DataTuple real, DataTuple pred) {
        int i = 0;
        while (i < this.m_Dim) {
            double real_i = this.getAttr(i).getNumeric(real);
            double predicted_i = this.getAttr(i).getNumeric(pred);
            double err = Math.abs(real_i - predicted_i) / real_i;
            ClusLogger.info(real_i);
            int n = i++;
            this.m_SumRelErr[n] = this.m_SumRelErr[n] + err;
        }
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return null;
    }

    @Override
    public double getModelErrorComponent(int i) {
        int nb = this.getNbExamples();
        double err = (double)nb != 0.0 ? this.m_SumRelErr[i] / (double)nb : 0.0;
        ClusLogger.info(err);
        return err;
    }

    @Override
    public String getName() {
        return "Relative Error" + this.getAdditionalInfoFormatted();
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

