/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ContingencyTable
extends ClusNominalError
implements ComponentError {
    public static final long serialVersionUID = 1L;
    protected static final String REAL_PRED = "REAL\\PRED";
    protected int[][][] m_ContTable;

    public ContingencyTable(ClusErrorList par, NominalAttrType[] nom) {
        this(par, nom, "");
    }

    public ContingencyTable(ClusErrorList par, NominalAttrType[] nom, String info) {
        super(par, nom);
        this.m_ContTable = new int[this.m_Dim][][];
        for (int i = 0; i < this.m_Dim; ++i) {
            int size = this.m_Attrs[i].getNbValuesInclMissing();
            this.m_ContTable[i] = new int[size][size];
        }
        this.setAdditionalInfo(info);
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    public int calcNbTotal(int k) {
        int sum = 0;
        int size = this.m_Attrs[k].getNbValues();
        int[][] table = this.m_ContTable[k];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                sum += table[i][j];
            }
        }
        return sum;
    }

    public int calcNbCorrect(int k) {
        int sum = 0;
        int size = this.m_Attrs[k].getNbValues();
        int[][] table = this.m_ContTable[k];
        for (int j = 0; j < size; ++j) {
            sum += table[j][j];
        }
        return sum;
    }

    public double calcXSquare(int k) {
        int size = this.m_Attrs[k].getNbValues();
        int[] ri = new int[size];
        int[] cj = new int[size];
        for (int j = 0; j < size; ++j) {
            ri[j] = this.sumRow(k, j);
            cj[j] = this.sumColumn(k, j);
        }
        double xsquare = 0.0;
        int nb = this.getNbExamples();
        int[][] table = this.m_ContTable[k];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double eij = (double)ri[i] * (double)cj[j] / (double)nb;
                double err = (double)table[i][j] - eij;
                if (err == 0.0) continue;
                xsquare += err * err / eij;
            }
        }
        return xsquare;
    }

    public double calcCramerV(int k) {
        int q = this.m_Attrs[k].getNbValues();
        int n = this.calcNbTotal(k);
        double div = (double)n * (double)(q - 1);
        return Math.sqrt(this.calcXSquare(k) / div);
    }

    public double calcAccuracy(int k) {
        return (double)this.calcNbCorrect(k) / (double)this.calcNbTotal(k);
    }

    public double calcDefaultAccuracy(int i) {
        return 0.0;
    }

    @Override
    public double getModelErrorComponent(int i) {
        return this.calcAccuracy(i);
    }

    public double getModelComponent() {
        double sum = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            sum += this.calcAccuracy(i);
        }
        return sum / (double)this.m_Dim;
    }

    public void showAccuracy(PrintWriter out, int i) {
        int nbcorr = this.calcNbCorrect(i);
        int nbtot = this.calcNbTotal(i);
        double acc = (double)nbcorr / (double)nbtot;
        out.print("Accuracy: " + ClusFormat.SIX_AFTER_DOT.format(acc));
        out.println();
    }

    @Override
    public void add(ClusError other) {
        ContingencyTable cont = (ContingencyTable)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int[][] t1 = this.m_ContTable[i];
            int[][] t2 = cont.m_ContTable[i];
            int size = t1.length;
            for (int j = 0; j < size; ++j) {
                for (int k = 0; k < size; ++k) {
                    int[] nArray = t1[j];
                    int n = k;
                    nArray[n] = nArray[n] + t2[j][k];
                }
            }
        }
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        if (detail == 3) {
            out.print(this.getPrefix() + "[");
            for (int i = 0; i < this.m_Dim; ++i) {
                if (i != 0) {
                    out.print(",");
                }
                double acc = this.calcAccuracy(i);
                out.print(ClusFormat.SIX_AFTER_DOT.format(acc));
            }
            out.println("]");
        } else {
            for (int i = 0; i < this.m_Dim; ++i) {
                out.println();
                out.println(this.getPrefix() + "Attribute: " + this.m_Attrs[i].getName());
                this.showContTable(out, i);
            }
        }
    }

    public int sumColumn(int[][] table, int j) {
        int sum = 0;
        for (int i = 0; i < table.length; ++i) {
            sum += table[i][j];
        }
        return sum;
    }

    public int sumRow(int[][] table, int i) {
        int sum = 0;
        for (int j = 0; j < table.length; ++j) {
            sum += table[i][j];
        }
        return sum;
    }

    public int sumColumn(int k, int j) {
        int sum = 0;
        int size = this.m_Attrs[k].getNbValues();
        int[][] table = this.m_ContTable[k];
        for (int i = 0; i < size; ++i) {
            sum += table[i][j];
        }
        return sum;
    }

    public int sumRow(int k, int i) {
        int sum = 0;
        int size = this.m_Attrs[k].getNbValues();
        int[][] table = this.m_ContTable[k];
        for (int j = 0; j < size; ++j) {
            sum += table[i][j];
        }
        return sum;
    }

    public void showContTable(PrintWriter out, int i) {
        int j;
        String str;
        int j2;
        int[][] table = this.m_ContTable[i];
        int size = this.m_Attrs[i].getNbValues();
        if (this.m_Attrs[i].hasMissing()) {
            ++size;
        }
        int[] wds = new int[size + 2];
        wds[0] = REAL_PRED.length();
        for (j2 = 0; j2 < size; ++j2) {
            wds[j2 + 1] = this.m_Attrs[i].getValueOrMissing(j2).length() + 1;
        }
        for (j2 = 0; j2 < size; ++j2) {
            wds[0] = Math.max(wds[0], this.m_Attrs[i].getValueOrMissing(j2).length());
            for (int k = 0; k < size; ++k) {
                String str2 = String.valueOf(table[j2][k]);
                wds[k + 1] = Math.max(wds[k + 1], str2.length() + 1);
            }
            str = String.valueOf(this.sumRow(table, j2));
            wds[size + 1] = Math.max(wds[size + 1], str.length() + 1);
        }
        for (int k = 0; k < size; ++k) {
            str = String.valueOf(this.sumColumn(table, k));
            wds[k + 1] = Math.max(wds[k + 1], str.length() + 1);
        }
        wds[size + 1] = Math.max(wds[size + 1], String.valueOf(this.getNbExamples()).length() + 1);
        int s = 0;
        for (int j3 = 0; j3 < size + 2; ++j3) {
            s += wds[j3];
        }
        String horiz = this.getPrefix() + "  " + StringUtils.makeString('-', s + (size + 1) * 2);
        out.print(this.getPrefix() + "  ");
        this.printString(out, wds[0], REAL_PRED);
        out.print(" |");
        for (j = 0; j < size; ++j) {
            this.printString(out, wds[j + 1], this.m_Attrs[i].getValueOrMissing(j));
            out.print(" |");
        }
        out.println();
        out.println(horiz);
        for (j = 0; j < size; ++j) {
            out.print(this.getPrefix() + "  ");
            this.printString(out, wds[0], this.m_Attrs[i].getValueOrMissing(j));
            out.print(" |");
            for (int k = 0; k < size; ++k) {
                this.printString(out, wds[k + 1], String.valueOf(table[j][k]));
                out.print(" |");
            }
            this.printString(out, wds[size + 1], String.valueOf(this.sumRow(table, j)));
            out.println();
        }
        out.println(horiz);
        out.print(this.getPrefix() + "  ");
        out.print(StringUtils.makeString(' ', wds[0]));
        out.print(" |");
        for (int k = 0; k < size; ++k) {
            this.printString(out, wds[k + 1], String.valueOf(this.sumColumn(table, k)));
            out.print(" |");
        }
        this.printString(out, wds[size + 1], String.valueOf(this.getNbExamples()));
        out.println();
        out.print(this.getPrefix() + "  ");
        this.showAccuracy(out, i);
        out.print(this.getPrefix() + "  ");
        double cramer = this.calcCramerV(i);
        out.println("Cramer's coefficient: " + ClusFormat.SIX_AFTER_DOT.format(cramer));
        out.println();
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        if (!detail) {
            for (int i = 0; i < this.m_Dim; ++i) {
                out.print(this.getPrefix() + "Attribute: " + this.m_Attrs[i].getName() + " - ");
                this.showAccuracy(out, i);
            }
        }
    }

    public void printString(PrintWriter out, int wd, String str) {
        out.print(StringUtils.makeString(' ', wd - str.length()));
        out.print(str);
    }

    @Override
    public String getName() {
        return "Classification Error" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new ContingencyTable(par, this.m_Attrs, this.getAdditionalInfo());
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        for (int i = 0; i < this.m_Dim; ++i) {
            int[] nArray = this.m_ContTable[i][this.getAttr(i).getNominal(tuple)];
            int n = predicted[i];
            nArray[n] = nArray[n] + 1;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public double get_error_classif() {
        return 1.0 - this.get_accuracy();
    }

    public double get_TP() {
        return this.calcNbCorrect(0);
    }

    @Override
    public double get_accuracy() {
        return this.calcAccuracy(0);
    }

    @Override
    public double get_precision() {
        return 0.0;
    }

    @Override
    public double get_recall() {
        return 0.0;
    }

    @Override
    public double get_auc() {
        return 0.0;
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }
}

