/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNominalError;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class Accuracy
extends ClusNominalError
implements ComponentError {
    public static final long serialVersionUID = 1L;
    protected int[] m_NbCorrect;
    protected int[] m_NbKnown;

    public Accuracy(ClusErrorList par, NominalAttrType[] nom) {
        this(par, nom, "");
    }

    public Accuracy(ClusErrorList par, NominalAttrType[] nom, String info) {
        super(par, nom);
        this.m_NbCorrect = new int[this.m_Dim];
        this.m_NbKnown = new int[this.m_Dim];
        this.setAdditionalInfo(info);
    }

    @Override
    public boolean shouldBeLow() {
        return false;
    }

    @Override
    public void reset() {
        Arrays.fill(this.m_NbCorrect, 0);
        Arrays.fill(this.m_NbKnown, 0);
    }

    @Override
    public void add(ClusError other) {
        Accuracy acc = (Accuracy)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_NbCorrect[n] = this.m_NbCorrect[n] + acc.m_NbCorrect[i];
            int n2 = i;
            this.m_NbKnown[n2] = this.m_NbKnown[n2] + acc.m_NbKnown[i];
        }
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        this.showModelError(out, detail ? 1 : 0);
    }

    public double getAccuracy(int i) {
        return this.getModelErrorComponent(i);
    }

    @Override
    public double getModelErrorComponent(int i) {
        return (double)this.m_NbCorrect[i] / (double)this.m_NbKnown[i];
    }

    @Override
    public double getModelError() {
        double avg = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            avg += this.getModelErrorComponent(i);
        }
        return avg / (double)this.m_Dim;
    }

    @Override
    public String getName() {
        return "Accuracy" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new Accuracy(par, this.m_Attrs, this.getAdditionalInfo());
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        int[] predicted = pred.getNominalPred();
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            if (attr.getNominal(tuple) == predicted[i]) {
                int n = i;
                this.m_NbCorrect[n] = this.m_NbCorrect[n] + 1;
            }
            int n = i;
            this.m_NbKnown[n] = this.m_NbKnown[n] + 1;
        }
    }

    @Override
    public void addExample(DataTuple tuple, DataTuple pred) {
        for (int i = 0; i < this.m_Dim; ++i) {
            NominalAttrType attr = this.getAttr(i);
            if (attr.isMissing(tuple)) continue;
            if (attr.getNominal(tuple) == attr.getNominal(pred)) {
                int n = i;
                this.m_NbCorrect[n] = this.m_NbCorrect[n] + 1;
            }
            int n = i;
            this.m_NbKnown[n] = this.m_NbKnown[n] + 1;
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }
}

