/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.error;

import java.io.PrintWriter;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusNumericError;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class AbsoluteError
extends ClusNumericError {
    public static final long serialVersionUID = 1L;
    protected double[] m_AbsError;
    protected double[] m_AbsDefError;

    public AbsoluteError(ClusErrorList par, NumericAttrType[] num) {
        this(par, num, "");
    }

    public AbsoluteError(ClusErrorList par, NumericAttrType[] num, String info) {
        super(par, num);
        this.m_AbsError = new double[this.m_Dim];
        this.m_AbsDefError = new double[this.m_Dim];
        this.setAdditionalInfo(info);
    }

    @Override
    public double getModelError() {
        double avg_abs = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            avg_abs += this.m_AbsError[i];
        }
        return avg_abs / (double)this.m_Dim;
    }

    @Override
    public void addExample(double[] real, double[] predicted) {
        int i = 0;
        while (i < this.m_Dim) {
            double err = real[i] - predicted[i];
            int n = i++;
            this.m_AbsError[n] = this.m_AbsError[n] + Math.abs(err);
        }
    }

    @Override
    public void addInvalid(DataTuple tuple) {
    }

    @Override
    public void addExample(DataTuple tuple, ClusStatistic pred) {
        double[] predicted = pred.getNumericPred();
        int i = 0;
        while (i < this.m_Dim) {
            double err = this.m_Attrs[i].getNumeric(tuple) - predicted[i];
            int n = i++;
            this.m_AbsError[n] = this.m_AbsError[n] + Math.abs(err);
        }
    }

    @Override
    public void add(ClusError other) {
        AbsoluteError oe = (AbsoluteError)other;
        for (int i = 0; i < this.m_Dim; ++i) {
            int n = i;
            this.m_AbsError[n] = this.m_AbsError[n] + oe.m_AbsError[i];
            int n2 = i;
            this.m_AbsDefError[n2] = this.m_AbsDefError[n2] + oe.m_AbsDefError[i];
        }
    }

    public void showDefaultError(PrintWriter out, boolean detail) {
        out.println(this.getPrefix() + "Default error: " + " " + this.showDoubleArray(this.m_AbsDefError));
    }

    @Override
    public void showModelError(PrintWriter out, int detail) {
        ClusNumberFormat fr = this.getFormat();
        StringBuffer buf = new StringBuffer();
        buf.append(this.showDoubleArray(this.m_AbsError, this.getNbExamples()));
        if (this.m_Dim > 1) {
            buf.append(": " + fr.format(this.getModelError() / (double)this.getNbExamples()));
        }
        out.println(buf.toString());
    }

    public void showRelativeError(PrintWriter out, boolean detail) {
        out.println(this.getPrefix() + "Relative error: " + "" + this.showDoubleArray(this.m_AbsError, this.m_AbsDefError));
    }

    public void showSummaryError(PrintWriter out, boolean detail) {
        ClusNumberFormat fr = this.getFormat();
        double ss_def = 0.0;
        double ss_tree = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            ss_tree += this.m_AbsError[i];
            ss_def += this.m_AbsDefError[i];
        }
        double re = ss_def != 0.0 ? ss_tree / ss_def : 0.0;
        out.println(this.getPrefix() + "Sum over components RE: " + fr.format(re) + " = " + fr.format(ss_tree) + " / " + fr.format(ss_def));
    }

    public double getSummaryError() {
        double ss_tree = 0.0;
        for (int i = 0; i < this.m_Dim; ++i) {
            ss_tree += this.m_AbsError[i];
        }
        return ss_tree;
    }

    @Override
    public String getName() {
        return "Mean absolute error (MAE)" + this.getAdditionalInfoFormatted();
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new AbsoluteError(par, this.m_Attrs, this.getAdditionalInfo());
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

