/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.timeseries;

import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.util.exception.ClusException;

public class TSCTimeSeriesDist
extends TimeSeriesDist {
    public static final long serialVersionUID = 1L;

    public TSCTimeSeriesDist(TimeSeriesAttrType attr) {
        super(attr);
    }

    @Override
    public double calcDistance(TimeSeries t1, TimeSeries t2) throws ClusException {
        double[] ts1 = t1.getValues();
        double[] ts2 = t2.getValues();
        double mean_ts1 = this.calculateMean(ts1);
        double mean_ts2 = this.calculateMean(ts2);
        double cc = 0.0;
        double sum_ts1_sqr = 0.0;
        double sum_ts2_sqr = 0.0;
        double sum_ts1_ts2 = 0.0;
        if (ts1.length != ts2.length) {
            throw new ClusException("TimeSeriesCorrelation applies only to Time Series with equal length");
        }
        for (int k = 0; k < ts1.length; ++k) {
            sum_ts1_ts2 += (ts1[k] - mean_ts1) * (ts2[k] - mean_ts2);
            sum_ts1_sqr += Math.pow(ts1[k] - mean_ts1, 2.0);
            sum_ts2_sqr += Math.pow(ts2[k] - mean_ts2, 2.0);
        }
        cc = 1.0 - Math.abs(sum_ts1_ts2 / Math.sqrt(sum_ts1_sqr * sum_ts2_sqr));
        return cc;
    }

    public double calculateMean(double[] ts) {
        double sum = 0.0;
        for (int k = 0; k < ts.length; ++k) {
            sum += ts[k];
        }
        return sum /= (double)ts.length;
    }

    @Override
    public String getDistanceName() {
        return "TSCTimeSeriesDist";
    }
}

