/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.timeseries;

import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;

public class DTWTimeSeriesDist
extends TimeSeriesDist {
    public static final long serialVersionUID = 1L;

    public DTWTimeSeriesDist(TimeSeriesAttrType attr) {
        super(attr);
    }

    public double calcDistance(TimeSeries t1, TimeSeries t2, int adjustmentWindow) {
        int i;
        int m = t1.length();
        int n = t2.length();
        double[][] wrappingPathMatrix = new double[m][n];
        double[] vt1 = t1.getValues();
        double[] vt2 = t2.getValues();
        wrappingPathMatrix[0][0] = Math.abs(vt1[0] - vt2[0]) * 2.0;
        int aw = Math.min(m, adjustmentWindow);
        for (i = 1; i < aw; ++i) {
            wrappingPathMatrix[i][0] = wrappingPathMatrix[i - 1][0] + Math.abs(vt1[i] - vt2[0]);
        }
        for (i = aw; i < m; ++i) {
            wrappingPathMatrix[i][0] = Double.POSITIVE_INFINITY;
        }
        aw = Math.min(n, adjustmentWindow);
        for (i = 1; i < aw; ++i) {
            wrappingPathMatrix[0][i] = wrappingPathMatrix[0][i - 1] + Math.abs(vt1[0] - vt2[i]);
        }
        for (i = aw; i < n; ++i) {
            wrappingPathMatrix[0][i] = Double.POSITIVE_INFINITY;
        }
        for (int k = 2; k < m + n - 1; ++k) {
            for (int i2 = Math.max(k - n + 1, 1); i2 < Math.min(k, m); ++i2) {
                if (Math.abs(2 * i2 - k) <= adjustmentWindow) {
                    double dfk = Math.abs(vt1[i2] - vt2[k - i2]);
                    wrappingPathMatrix[i2][k - i2] = Math.min(wrappingPathMatrix[i2][k - i2 - 1] + dfk, Math.min(wrappingPathMatrix[i2 - 1][k - i2] + dfk, wrappingPathMatrix[i2 - 1][k - i2 - 1] + dfk * 2.0));
                    continue;
                }
                wrappingPathMatrix[i2][k - i2] = Double.POSITIVE_INFINITY;
            }
        }
        return wrappingPathMatrix[m - 1][n - 1] / (double)(m + n);
    }

    @Override
    public double calcDistance(TimeSeries t1, TimeSeries t2) {
        return this.calcDistance(t1, t2, Math.max(Math.max(Math.abs(t1.length() - t2.length()) + 1, t1.length() / 2), t2.length() / 2));
    }

    @Override
    public String getDistanceName() {
        return "DTWTimeSeriesDist";
    }
}

