/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.primitive.relief;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;

public class Levenshtein {
    String m_str1;
    String m_str2;
    int m_len1;
    int m_len2;
    double[] m_memo;
    double m_dist = -1.0;
    double m_charDist = 1.0;

    public Levenshtein(String str1, String str2) {
        this.m_str1 = str1;
        this.m_str2 = str2;
        this.m_len1 = this.m_str1.length();
        this.m_len2 = this.m_str2.length();
        this.m_memo = new double[this.m_len1 + 1 + this.m_len2];
        if (this.m_len1 == 0 && this.m_len2 == 0) {
            this.m_dist = 0.0;
        } else if (this.m_len1 == 0 || this.m_len2 == 0) {
            this.m_dist = 1.0;
        } else {
            this.computeDist();
            this.m_dist = this.m_memo[this.m_len2] / (double)Math.max(this.m_len1, this.m_len2);
        }
    }

    public Levenshtein(DataTuple t1, DataTuple t2, StringAttrType attr) {
        this(attr.getString(t1), attr.getString(t2));
    }

    public void computeDist() {
        int processed;
        int i;
        for (i = this.m_len1 - 1; i >= 0; --i) {
            this.m_memo[i] = this.m_len1 - i;
        }
        for (i = this.m_len1 + 1; i < this.m_memo.length; ++i) {
            this.m_memo[i] = i - this.m_len1;
        }
        int place1 = processed = 0;
        int place2 = processed;
        boolean nextRound = true;
        while (nextRound) {
            int ind;
            this.m_memo[this.m_len1] = Math.min(Math.min(this.m_memo[this.m_len1 - 1] + 1.0, this.m_memo[this.m_len1 + 1] + 1.0), this.m_memo[this.m_len1] + (this.m_str1.charAt(place1) == this.m_str2.charAt(place2) ? 0.0 : this.m_charDist));
            for (int i2 = processed + 1; i2 < this.m_len1; ++i2) {
                ind = this.m_len1 - (i2 - processed);
                this.m_memo[ind] = Math.min(Math.min(this.m_memo[ind - 1] + 1.0, this.m_memo[ind + 1] + 1.0), this.m_memo[ind] + (this.m_str1.charAt(i2) == this.m_str2.charAt(place2) ? 0.0 : this.m_charDist));
            }
            for (int j = processed + 1; j < this.m_len2; ++j) {
                ind = this.m_len1 + (j - processed);
                this.m_memo[ind] = Math.min(Math.min(this.m_memo[ind - 1] + 1.0, this.m_memo[ind + 1] + 1.0), this.m_memo[ind] + (this.m_str1.charAt(place1) == this.m_str2.charAt(j) ? 0.0 : this.m_charDist));
            }
            if (processed < this.m_len1 - 1) {
                ++place1;
            }
            if (processed < this.m_len2 - 1) {
                ++place2;
            }
            nextRound = this.m_len2 > ++processed || this.m_len1 > processed;
        }
    }

    public double getDist() {
        return this.m_dist;
    }
}

