/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex.tuples;

import java.io.IOException;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.IntegerAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.math.matrix.MSymMatrix;

public class SSPDMatrix
extends ClusDistance {
    public static final long serialVersionUID = 1L;
    protected MSymMatrix m_Matrix;
    protected IntegerAttrType m_Target;

    public SSPDMatrix(int size) {
        this.m_Matrix = new MSymMatrix(size);
    }

    public void setTarget(ClusAttrType[] target) throws ClusException {
        if (target.length != 1) {
            throw new ClusException("Only one target allowed in SSPD modus");
        }
        this.m_Target = (IntegerAttrType)target[0];
    }

    public static SSPDMatrix read(String filename, Settings sett) throws IOException {
        ClusReader reader = new ClusReader(filename, sett);
        int nb = 0;
        while (!reader.isEol()) {
            reader.readFloat();
            ++nb;
        }
        ClusLogger.info("Loading SSPD Matrix: " + filename + " (Size: " + nb + ")");
        SSPDMatrix matrix = new SSPDMatrix(nb);
        reader.reOpen();
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                double value = reader.readFloat();
                matrix.m_Matrix.add_sym(i, j, value * value);
            }
            if (reader.isEol()) continue;
            throw new IOException("SSPD Matrix is not square");
        }
        reader.close();
        return matrix;
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) {
        int idx = this.m_Target.getArrayIndex();
        int i1 = t1.getIntVal(idx);
        int i2 = t2.getIntVal(idx);
        return this.m_Matrix.get(i1, i2);
    }

    @Override
    public String getDistanceName() {
        return "SSPD Matrix";
    }
}

