/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex.sets;

import java.util.Arrays;
import si.ijs.kt.clus.data.type.complex.SetAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.SetDistance;
import si.ijs.kt.clus.ext.structuredTypes.Set;
import si.ijs.kt.clus.util.exception.ClusException;

public class GSMDistance
extends SetDistance {
    private static final long serialVersionUID = 1L;
    private int maximal_possible_distance = 1;

    public GSMDistance(SetAttrType attr, ClusDistance innerDistance, int maximal_possible_distance) {
        super(attr, innerDistance);
    }

    @Override
    public double calcDistance(Set set1, Set set2) throws ClusException {
        ClusDistance clusDistance = this.m_ChildDistances[0];
        double distance = 0.0;
        int m = set1.size();
        int n = set2.size();
        int maxCostFlow = Math.abs(m - n);
        int flow = Math.min(m, n);
        double[][] distances = new double[m + 1][n + 1];
        int i = 0;
        int j = 0;
        if (flow > 0) {
            for (Object element1 : set1.getValues()) {
                j = 0;
                for (Object element2 : set2.getValues()) {
                    distances[i][j] = clusDistance == null ? Math.abs((Double)element1 - (Double)element2) : clusDistance.calcDistance(element1, element2);
                    ++j;
                }
                ++i;
            }
        }
        int mini = -1;
        int minj = -1;
        while (flow > 0) {
            double minCost = Double.MAX_VALUE;
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    if (!(distances[i][j] < minCost)) continue;
                    minCost = distances[i][j];
                    mini = i;
                    minj = j;
                }
            }
            --flow;
            distance += minCost;
            Arrays.fill(distances[mini], Double.MAX_VALUE);
            for (i = 0; i < m; ++i) {
                distances[i][minj] = Double.MAX_VALUE;
            }
        }
        return distance += (double)(maxCostFlow * this.maximal_possible_distance / 2);
    }

    @Override
    public String getDistanceName() {
        return "Greedy matching (sets)";
    }
}

