/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.distance.complex;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.distance.complex.ClusStructuredDistance;
import si.ijs.kt.clus.ext.structuredTypes.Tuple;
import si.ijs.kt.clus.ext.structuredTypes.TupleStatistic;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class TupleDistance
extends ClusStructuredDistance {
    public static final long serialVersionUID = 1L;
    protected TupleAttrType m_Attr;

    public TupleDistance(TupleAttrType attr) {
        this.m_Attr = attr;
    }

    public abstract double calcDistance(Tuple var1, Tuple var2) throws ClusException;

    @Override
    public double calcDistance(Object t1, Object t2) throws ClusException {
        Tuple s1 = (Tuple)t1;
        Tuple s2 = (Tuple)t2;
        return this.calcDistance(s1, s2);
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) throws ClusException {
        Tuple s1 = this.m_Attr.getTuple(t1);
        Tuple s2 = this.m_Attr.getTuple(t2);
        return this.calcDistance(s1, s2);
    }

    @Override
    public double calcDistanceToCentroid(DataTuple t1, ClusStatistic s2) throws ClusException {
        Tuple tu1 = this.m_Attr.getTuple(t1);
        TupleStatistic stat = (TupleStatistic)s2;
        return this.calcDistance(tu1, stat.getRepresentativeMedoid());
    }
}

