/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class SparseNumericAttrType
extends NumericAttrType {
    public static final long serialVersionUID = 1L;
    protected Integer m_IntIndex;
    protected ArrayList<SparseDataTuple> m_Examples;
    protected double m_ExampleWeight;
    protected static final Double[] DOUBLES = SparseNumericAttrType.createPredefinedDoubles();

    public SparseNumericAttrType(String name) {
        super(name);
        this.setSparse(true);
        this.m_Examples = new ArrayList();
    }

    public SparseNumericAttrType(NumericAttrType type) {
        super(type.getName());
        this.setIndex(type.getIndex());
        this.setSparse(true);
        this.m_Examples = new ArrayList();
    }

    @Override
    public SparseNumericAttrType cloneType() {
        SparseNumericAttrType at = new SparseNumericAttrType(this.m_Name);
        this.cloneType(at);
        at.setIndex(this.getIndex());
        at.m_Sparse = this.m_Sparse;
        at.setExamples(this.getExamples());
        at.m_ExampleWeight = this.m_ExampleWeight;
        return at;
    }

    @Override
    public void setIndex(int idx) {
        this.m_Index = idx;
        this.m_IntIndex = new Integer(idx);
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.None;
    }

    public ArrayList<SparseDataTuple> getExamples() {
        return this.m_Examples;
    }

    public double getExampleWeight() {
        return this.m_ExampleWeight;
    }

    public void setExamples(ArrayList<SparseDataTuple> ex) {
        this.m_Examples = ex;
    }

    public void resetExamples() {
        this.m_Examples = new ArrayList();
        this.m_ExampleWeight = 0.0;
    }

    public void addExample(SparseDataTuple tuple) {
        this.m_Examples.add(tuple);
        this.m_ExampleWeight += tuple.getWeight();
    }

    @Deprecated
    public ArrayList<SparseDataTuple> pruneExampleList(RowData data) {
        ArrayList<DataTuple> dataList = data.toArrayList();
        ArrayList<SparseDataTuple> newExamples = new ArrayList<SparseDataTuple>();
        for (int i = 0; i < this.m_Examples.size(); ++i) {
            if (!dataList.contains(this.m_Examples.get(i))) continue;
            newExamples.add(this.m_Examples.get(i));
        }
        return newExamples;
    }

    @Override
    public double getNumeric(DataTuple tuple) {
        return ((SparseDataTuple)tuple).getDoubleValueSparse(this.getIndex());
    }

    @Override
    public boolean isMissing(DataTuple tuple) {
        return ((SparseDataTuple)tuple).getDoubleValueSparse(this.m_IntIndex) == Double.POSITIVE_INFINITY;
    }

    protected static Double[] createPredefinedDoubles() {
        Double[] values = new Double[10];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Double(i);
        }
        return values;
    }

    @Override
    public void setNumeric(DataTuple tuple, double value) {
        Double d_value = null;
        d_value = new Double(value);
        ((SparseDataTuple)tuple).setDoubleValueSparse(d_value, this.m_IntIndex);
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    public class MySerializable
    extends ClusSerializable {
        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            if (!data.readNoSpace()) {
                return false;
            }
            double value = data.getFloat();
            SparseNumericAttrType.this.setNumeric(tuple, value);
            return true;
        }
    }
}

