/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.primitive;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import si.ijs.kt.clus.algo.kNN.distance.valentin.NumericStatistic;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.cols.ColTarget;
import si.ijs.kt.clus.data.cols.attribute.ClusAttribute;
import si.ijs.kt.clus.data.cols.attribute.NumericTarget;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRNode;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class NumericAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    public static final double MISSING = Double.POSITIVE_INFINITY;
    protected boolean m_Sparse;
    private NumericStatistic m_StatNumeric;

    public NumericAttrType(String name) {
        super(name);
    }

    public void setStatistic(NumericStatistic stat) {
        this.m_StatNumeric = stat;
    }

    public NumericStatistic getStatistic() {
        return this.m_StatNumeric;
    }

    @Override
    public ClusAttrType cloneType() {
        NumericAttrType at = new NumericAttrType(this.m_Name);
        this.cloneType(at);
        at.m_Sparse = this.m_Sparse;
        return at;
    }

    @Override
    public boolean isSparse() {
        return this.m_Sparse;
    }

    public void setSparse(boolean sparse) {
        this.m_Sparse = sparse;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Numeric;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Double;
    }

    @Override
    public int getMaxNbStats() {
        return 2;
    }

    @Override
    public String getString(DataTuple tuple) {
        double val = this.getNumeric(tuple);
        if (this.getStatus().equals((Object)ClusAttrType.Status.Key)) {
            return String.valueOf((int)val);
        }
        return val == Double.POSITIVE_INFINITY ? "?" : String.valueOf(val);
    }

    @Override
    public boolean isMissing(DataTuple tuple) {
        return tuple.getDoubleVal(this.m_ArrayIndex) == Double.POSITIVE_INFINITY;
    }

    @Override
    public double getNumeric(DataTuple tuple) {
        return tuple.getDoubleVal(this.m_ArrayIndex);
    }

    public void setNumeric(DataTuple tuple, double value) {
        tuple.setDoubleVal(value, this.m_ArrayIndex);
    }

    @Override
    public int compareValue(DataTuple t1, DataTuple t2) {
        double v2;
        double v1 = t1.getDoubleVal(this.m_ArrayIndex);
        if (v1 == (v2 = t2.getDoubleVal(this.m_ArrayIndex))) {
            return 0;
        }
        return v1 > v2 ? 1 : -1;
    }

    @Override
    public ClusAttribute createTargetAttr(ColTarget target) {
        return new NumericTarget(target, this, this.getArrayIndex());
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print("numeric");
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    @Override
    public void setToMissing(DataTuple tuple) {
        this.setNumeric(tuple, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public class MySerializable
    extends ClusSerializable {
        public int m_NbZero;
        public int m_NbNeg;
        public int m_NbTotal;

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            if (!data.readNoSpace()) {
                return false;
            }
            double val = data.getFloat();
            tuple.setDoubleVal(val, NumericAttrType.this.getArrayIndex());
            if (val == Double.POSITIVE_INFINITY) {
                NumericAttrType.this.incNbMissing();
                ++this.m_NbZero;
            }
            if (val == 0.0) {
                ++this.m_NbZero;
            } else if (val < 0.0) {
                ++this.m_NbNeg;
            }
            ++this.m_NbTotal;
            return true;
        }

        @Override
        public boolean calculateHMTRAttribute(ClusReader data, DataTuple tuple, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy) throws IOException {
            int key = schema.getKeyAttribute().length;
            int desc = schema.getDescriptiveAttributes().length;
            int dis = schema.getDisabled().getTotal();
            int nbNominalTargets = schema.getNbNominalTargetAttributes();
            if (nbNominalTargets > 0) {
                throw new IOException("Nominal attributes used as targets in Hierarchical Multi-Target Regression!");
            }
            ClusAttrType[] targets = tuple.getSchema().getTargetAttributes();
            double val = Double.NaN;
            int ind = NumericAttrType.this.m_Index - key - dis - desc;
            String name = targets[ind].getName();
            List<ClusHMTRNode> nodes = hmtrHierarchy.getNodes();
            val = this.calcHMTR(nodes, name, tuple);
            if (Double.isNaN(val)) {
                System.err.println("Either error calculating aggregate or certain value is missing");
                val = Double.POSITIVE_INFINITY;
            }
            tuple.setDoubleVal(val, NumericAttrType.this.getArrayIndex());
            if (val == Double.POSITIVE_INFINITY) {
                NumericAttrType.this.incNbMissing();
                ++this.m_NbZero;
            }
            if (val == 0.0) {
                ++this.m_NbZero;
            } else if (val < 0.0) {
                ++this.m_NbNeg;
            }
            ++this.m_NbTotal;
            return true;
        }

        @Override
        public boolean readHMTRAttribute(ClusReader data, DataTuple tuple, ClusSchema schema, ClusHMTRHierarchy hmtrHierarchy, String line) throws IOException {
            int key = schema.getKeyAttribute().length;
            int desc = schema.getDescriptiveAttributes().length;
            int dis = schema.getDisabled().getTotal();
            int tar = schema.getTargetAttributes().length;
            int pos = NumericAttrType.this.m_Index - key - dis - desc - tar + schema.getNbHMTRAttributes();
            String[] lineElements = line.split(",");
            if (data.getRow() == 232) {
                ClusLogger.info();
            }
            double val = Double.POSITIVE_INFINITY;
            val = !lineElements[pos].contains("?") ? Double.parseDouble(lineElements[pos]) : Double.POSITIVE_INFINITY;
            if (Double.isNaN(val)) {
                throw new IOException("Error reading HMTR aggregate from dump! Aggregation function is: " + NumericAttrType.this.getSettings().getHMTR().getHMTRAggregationName());
            }
            tuple.setDoubleVal(val, NumericAttrType.this.getArrayIndex());
            if (val == Double.POSITIVE_INFINITY) {
                NumericAttrType.this.incNbMissing();
                ++this.m_NbZero;
            }
            if (val == 0.0) {
                ++this.m_NbZero;
            } else if (val < 0.0) {
                ++this.m_NbNeg;
            }
            ++this.m_NbTotal;
            return true;
        }

        private double calcHMTR(List<ClusHMTRNode> nodes, String name, DataTuple tuple) throws IOException {
            for (ClusHMTRNode node : nodes) {
                if (!node.getName().equals(name)) continue;
                if (!node.isAggregate()) {
                    throw new IOException("Attribute " + node.getName() + " is  not aggregate!");
                }
                List<ClusHMTRNode> children = node.getChildren();
                double sum = 0.0;
                ArrayList<Double> values = new ArrayList<Double>();
                for (ClusHMTRNode child : children) {
                    double res;
                    if (child.isAggregate()) {
                        res = this.calcHMTR(nodes, child.getName(), tuple);
                        sum += res;
                        values.add(res);
                        continue;
                    }
                    res = this.getHMTRValue(tuple, child.getName());
                    sum += res;
                    values.add(res);
                }
                Collections.sort(values);
                switch (NumericAttrType.this.getSettings().getHMTR().getHMTRAggregation()) {
                    case SUM: {
                        return sum;
                    }
                    case AVG: {
                        return sum / (double)children.size();
                    }
                    case MEDIAN: {
                        int middle = values.size() / 2;
                        if (values.size() % 2 == 1) {
                            return (Double)values.get(middle);
                        }
                        return ((Double)values.get(middle - 1) + (Double)values.get(middle)) / 2.0;
                    }
                    case MIN: {
                        return (Double)Collections.min(values);
                    }
                    case MAX: {
                        return (Double)Collections.max(values);
                    }
                    case AND: {
                        double val;
                        for (int i = 0; i < values.size(); ++i) {
                            val = (Double)values.get(i);
                            if (val != 0.0 && val != 1.0) {
                                throw new IOException("Value " + val + " is not 1 or 0 while using AND or OR");
                            }
                            if (val != 0.0) continue;
                            return 0.0;
                        }
                        return 1.0;
                    }
                    case OR: {
                        double val;
                        for (int i = 0; i < values.size(); ++i) {
                            val = (Double)values.get(i);
                            if (val != 0.0 && val != 1.0) {
                                throw new IOException("Value " + val + " is not 1 or 0 while using AND or OR");
                            }
                            if (val != 1.0) continue;
                            return 1.0;
                        }
                        return 0.0;
                    }
                    case COUNT: {
                        return values.size();
                    }
                    case VAR: {
                        double sumDiffsSquared = 0.0;
                        double avg = sum / (double)children.size();
                        for (int i = 0; i < values.size(); ++i) {
                            double diff = (Double)values.get(i) - avg;
                            diff *= diff;
                            sumDiffsSquared += diff;
                        }
                        return sumDiffsSquared / (double)values.size();
                    }
                    case STDEV: {
                        double mean = sum / (double)children.size();
                        double temp = 0.0;
                        for (int i = 0; i < values.size(); ++i) {
                            double val = (Double)values.get(i);
                            double squrDiffToMean = Math.pow(val - mean, 2.0);
                            temp += squrDiffToMean;
                        }
                        double meanOfDiffs = temp / (double)values.size();
                        return Math.sqrt(meanOfDiffs);
                    }
                    case ZERO: {
                        return 0.0;
                    }
                    case ONE: {
                        return 1.0;
                    }
                }
            }
            return Double.NaN;
        }

        public double getHMTRValue(DataTuple tuple, String name) {
            ClusAttrType[] targets;
            double value = Double.NaN;
            for (ClusAttrType target : targets = tuple.getSchema().getTargetAttributes()) {
                if (!target.getName().equals(name)) continue;
                int i = target.getArrayIndex();
                value = tuple.getDoubleVal(i);
                break;
            }
            return value;
        }

        @Override
        public void term(ClusSchema schema) {
            if (this.m_NbNeg == 0 && this.m_NbZero > this.m_NbTotal * 5 / 10) {
                NumericAttrType.this.setSparse(true);
            }
        }
    }
}

