/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.data.type.complex;

import java.io.IOException;
import java.io.PrintWriter;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.structuredTypes.Tuple;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.io.ClusSerializable;

public class TupleAttrType
extends ClusAttrType {
    public static final long serialVersionUID = 1L;
    int m_Length = -1;

    public TupleAttrType(String name) {
        super(name);
    }

    public TupleAttrType(String name, String typeDefinition, ClusAttrType[] innerTypes) {
        super(name);
        typeDefinition = typeDefinition.toUpperCase();
        this.setTypeDefinition(typeDefinition);
        this.setInnerTypes(innerTypes);
    }

    @Override
    public ClusAttrType cloneType() {
        TupleAttrType tsat = new TupleAttrType(this.m_Name);
        return tsat;
    }

    @Override
    public ClusAttrType.AttributeType getAttributeType() {
        return ClusAttrType.AttributeType.Tuple;
    }

    @Override
    public ClusAttrType.ValueType getValueType() {
        return ClusAttrType.ValueType.Object;
    }

    @Override
    public String getTypeName() {
        return this.getAttributeType().getName();
    }

    public Tuple getTuple(DataTuple tuple) {
        return (Tuple)tuple.getObjVal(this.m_ArrayIndex);
    }

    public void setTuple(DataTuple tuple, Tuple value) {
        tuple.setObjectVal(value, this.m_ArrayIndex);
    }

    @Override
    public String getString(DataTuple tuple) {
        Tuple ts_data = (Tuple)tuple.getObjVal(this.m_ArrayIndex);
        return ts_data.toString();
    }

    @Override
    public void writeARFFType(PrintWriter wrt) throws ClusException {
        wrt.print("Tuple");
    }

    @Override
    public ClusSerializable createRowSerializable() throws ClusException {
        return new MySerializable();
    }

    public class MySerializable
    extends ClusSerializable {
        public String getString(DataTuple tuple) {
            Tuple ts_data = (Tuple)tuple.getObjVal(0);
            Object[] data = ts_data.getValues();
            String str = "[";
            for (int k = 0; k < data.length; ++k) {
                str.concat(String.valueOf(data[k]));
                if (k >= data.length - 1) continue;
                str.concat(", ");
            }
            str.concat("]");
            return str;
        }

        @Override
        public boolean read(ClusReader data, DataTuple tuple) throws IOException {
            String str = data.readTuple();
            if (str == null) {
                return false;
            }
            Tuple value = (Tuple)ClusAttrType.createDataObject(str, TupleAttrType.this);
            tuple.setObjectVal(value, TupleAttrType.this.getArrayIndex());
            if (TupleAttrType.this.m_Length == -1) {
                TupleAttrType.this.m_Length = value.length();
            }
            return true;
        }
    }
}

